/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.diameter.AVPList;
import org.cipango.diameter.DiameterCommand;
import org.cipango.diameter.Dictionary;
import org.cipango.diameter.Factory;
import org.cipango.diameter.base.Common;
import org.cipango.diameter.io.AbstractCodec;
import org.cipango.diameter.node.DiameterAnswer;
import org.cipango.diameter.node.DiameterMessage;
import org.cipango.diameter.node.DiameterRequest;

public class MessageCodec
extends AbstractCodec<DiameterMessage> {
    public static final int DIAMETER_VERSION_1 = 1;
    public static final int REQUEST_FLAG = 128;
    public static final int PROXIABLE_FLAG = 64;

    @Override
    public DiameterMessage decode(ByteBuffer buffer) throws IOException {
        DiameterCommand command;
        int i = buffer.getInt();
        int version = i >> 24 & 0xFF;
        if (version != 1) {
            throw new IOException("Unsupported diameter version: " + version);
        }
        i = buffer.getInt();
        int flags = i >> 24 & 0xFF;
        boolean isRequest = (flags & 0x80) == 128;
        int code = i & 0xFFFFFF;
        Dictionary dictionary = Dictionary.getInstance();
        DiameterCommand diameterCommand = command = isRequest ? dictionary.getRequest(code) : dictionary.getAnswer(code);
        if (command == null) {
            command = isRequest ? Factory.newRequest(code, "Unknown") : Factory.newAnswer(code, "Unknown");
        }
        DiameterMessage message = isRequest ? new DiameterRequest() : new DiameterAnswer();
        message.setApplicationId(buffer.getInt());
        message.setHopByHopId(buffer.getInt());
        message.setEndToEndId(buffer.getInt());
        message.setCommand(command);
        if (isRequest) {
            ((DiameterRequest)message).setUac(false);
        }
        message.setAVPList((AVPList)Common.__grouped.decode(buffer));
        return message;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer, DiameterMessage message) throws IOException {
        int start = buffer.position();
        buffer.position(start + 4);
        int flags = 0;
        DiameterCommand command = message.getCommand();
        if (command.isRequest()) {
            flags |= 0x80;
        }
        if (command.isProxiable()) {
            flags |= 0x40;
        }
        buffer.putInt(flags << 24 | command.getCode() & 0xFFFFFF);
        buffer.putInt(message.getApplicationId());
        buffer.putInt(message.getHopByHopId());
        buffer.putInt(message.getEndToEndId());
        buffer = Common.__grouped.encode(buffer, message.getAVPs());
        this.pokeInt(buffer, start, 0x1000000 | buffer.position() - start & 0xFFFFFF);
        return buffer;
    }
}

