/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.io;

import java.nio.ByteBuffer;
import org.cipango.diameter.io.DiameterCodec;

public abstract class AbstractCodec<T>
implements DiameterCodec<T> {
    public ByteBuffer ensureSpace(ByteBuffer buffer, int space) {
        if (buffer.remaining() < space) {
            while (space < buffer.capacity() / 2 && space < 128) {
                space *= 2;
            }
            ByteBuffer larger = ByteBuffer.allocate(buffer.capacity() + space);
            buffer.flip();
            larger.put(buffer);
            larger.position(buffer.position());
            return larger;
        }
        return buffer;
    }

    public ByteBuffer pokeInt(ByteBuffer buffer, int index, int value) {
        buffer.put(index, (byte)(value >> 24 & 0xFF));
        buffer.put(index + 1, (byte)(value >> 16 & 0xFF));
        buffer.put(index + 2, (byte)(value >> 8 & 0xFF));
        buffer.put(index + 3, (byte)(value & 0xFF));
        return buffer;
    }
}

