/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.diameter.AVP;
import org.cipango.diameter.Dictionary;
import org.cipango.diameter.Factory;
import org.cipango.diameter.Type;
import org.cipango.diameter.base.Common;
import org.cipango.diameter.io.AbstractCodec;

public class AVPCodec
extends AbstractCodec<AVP<?>> {
    private static final int AVP_VENDOR_FLAG = 128;
    private static final int AVP_MANDATORY_FLAG = 64;

    @Override
    public AVP<?> decode(ByteBuffer buffer) throws IOException {
        int code = buffer.getInt();
        int i = buffer.getInt();
        int flags = i >> 24 & 0xFF;
        int length = i & 0xFFFFFF;
        int dataLength = length - 8;
        int vendorId = 0;
        if ((flags & 0x80) == 128) {
            vendorId = buffer.getInt();
            dataLength -= 4;
        }
        ByteBuffer data = buffer.duplicate();
        data.position(buffer.position());
        data.limit(data.position() + dataLength);
        buffer.position(buffer.position() + (dataLength + 3 & 0xFFFFFFFC));
        Type<Object> type = Dictionary.getInstance().getType(vendorId, code);
        if (type == null) {
            type = Factory.newType("Unknown", vendorId, code, Common.__octetString);
        }
        AVP avp = new AVP(type);
        avp.setValue(type.getDataFormat().decode(data));
        return avp;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer, AVP avp) throws IOException {
        buffer = this.ensureSpace(buffer, 12);
        int flags = 0;
        if (avp.getType().isMandatory()) {
            flags |= 0x40;
        }
        int start = buffer.position();
        buffer.putInt(avp.getType().getCode());
        buffer.position(start + 8);
        if (avp.getType().isVendorSpecific()) {
            flags |= 0x80;
            buffer.putInt(avp.getType().getVendorId());
        }
        buffer = avp.getType().getDataFormat().encode(buffer, avp.getValue());
        buffer = this.ensureSpace(buffer, 8);
        this.pokeInt(buffer, start + 4, flags << 24 | buffer.position() - start & 0xFFFFFF);
        while (buffer.position() % 4 != 0) {
            buffer.put((byte)0);
        }
        return buffer;
    }
}

