/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.cipango.diameter.AVP;
import org.cipango.diameter.AVPList;
import org.cipango.diameter.Dictionary;
import org.cipango.diameter.Factory;
import org.cipango.diameter.ResultCode;
import org.cipango.diameter.base.Common;
import org.cipango.diameter.io.Codecs;
import org.cipango.diameter.node.AbstractDiameterConnector;
import org.cipango.diameter.node.DiameterAnswer;
import org.cipango.diameter.node.DiameterConnection;
import org.cipango.diameter.node.DiameterMessage;
import org.cipango.diameter.node.Peer;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DiameterSocketConnector
extends AbstractDiameterConnector {
    private static final Logger LOG = Log.getLogger(DiameterSocketConnector.class);
    public static final int DEFAULT_PORT = 3868;
    private ServerSocketChannel _serverChannel;

    @Override
    public void open() throws IOException {
        this._serverChannel = ServerSocketChannel.open();
        this._serverChannel.configureBlocking(true);
        this._serverChannel.socket().bind(new InetSocketAddress(InetAddress.getByName(this.getHost()), this.getPort()));
    }

    @Override
    public void close() throws IOException {
        if (this._serverChannel != null) {
            this._serverChannel.close();
        }
        this._serverChannel = null;
    }

    protected ServerSocket newServerSocket() throws IOException {
        ServerSocket ss = new ServerSocket();
        if (this.getHost() == null) {
            ss.bind(new InetSocketAddress(this.getPort()));
        } else {
            ss.bind(new InetSocketAddress(this.getHost(), this.getPort()));
        }
        return ss;
    }

    @Override
    public void accept(int acceptorID) throws IOException, InterruptedException {
        SocketChannel socket = this._serverChannel.accept();
        Connection connection = new Connection(socket);
        new Thread((Runnable)connection, "Connection-" + acceptorID).start();
    }

    @Override
    public DiameterConnection getConnection(Peer peer) throws IOException {
        int port = peer.getPort();
        if (port == 0) {
            port = 3868;
        }
        SocketChannel socket = peer.getAddress() != null ? SocketChannel.open(new InetSocketAddress(peer.getAddress(), port)) : SocketChannel.open(new InetSocketAddress(peer.getHost(), port));
        Connection connection = new Connection(socket);
        connection.setPeer(peer);
        new Thread((Runnable)connection, "Connection-" + peer.getHost()).start();
        return connection;
    }

    @Override
    public int getLocalPort() {
        return this.getPort();
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this._serverChannel == null || !this._serverChannel.isOpen()) {
            return null;
        }
        try {
            return ((InetSocketAddress)this._serverChannel.getLocalAddress()).getAddress();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected int getDefaultPort() {
        return 3868;
    }

    public class Connection
    implements Runnable,
    DiameterConnection {
        private SocketChannel _channel;
        private Peer _peer;

        public Connection(SocketChannel channel) throws IOException {
            this._channel = channel;
        }

        @Override
        public void setPeer(Peer peer) {
            this._peer = peer;
        }

        @Override
        public Peer getPeer() {
            return this._peer;
        }

        @Override
        public void stop() {
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
        }

        @Override
        public void write(DiameterMessage message) throws IOException {
            ByteBuffer buffer = DiameterSocketConnector.this.getBuffer(DiameterSocketConnector.this.getMessageBufferSize());
            buffer = Codecs.__message.encode(buffer, message);
            buffer.flip();
            this._channel.write(buffer);
            DiameterSocketConnector.this.returnBuffer(buffer);
            if (DiameterSocketConnector.this.getNode().isStatsOn()) {
                DiameterSocketConnector.this._messagesSent.incrementAndGet();
            }
            if (DiameterSocketConnector.this._listener != null) {
                DiameterSocketConnector.this._listener.messageSent(message, this);
            }
        }

        @Override
        public boolean isOpen() {
            return this._channel.isOpen();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ByteBuffer fb = ByteBuffer.allocate(4);
                while (DiameterSocketConnector.this.isStarted() && this.isOpen()) {
                    fb.clear();
                    int read = this._channel.read(fb);
                    if (read == -1) {
                        throw new EofException();
                    }
                    int length = (fb.get(1) & 0xFF) << 16 | (fb.get(2) & 0xFF) << 8 | fb.get(3) & 0xFF;
                    fb.flip();
                    ByteBuffer b = ByteBuffer.allocate(length);
                    b.put(fb);
                    for (int totalRead = 4; totalRead < length; totalRead += read) {
                        read = this._channel.read(b);
                        if (read != -1) continue;
                        throw new EofException();
                    }
                    b.flip();
                    DiameterMessage message = Codecs.__message.decode(b);
                    message.setConnection(this);
                    message.setNode(DiameterSocketConnector.this.getNode());
                    if (DiameterSocketConnector.this.getNode().isStatsOn()) {
                        DiameterSocketConnector.this._messagesReceived.incrementAndGet();
                    }
                    if (!message.isRequest()) {
                        int code;
                        int vendorId = 0;
                        AVP<Integer> avp = message.getAVPs().get(Common.RESULT_CODE);
                        if (avp != null) {
                            code = avp.getValue();
                        } else {
                            AVPList expRc = message.get(Common.EXPERIMENTAL_RESULT);
                            code = expRc.getValue(Common.EXPERIMENTAL_RESULT_CODE);
                            vendorId = expRc.getValue(Common.VENDOR_ID);
                        }
                        ResultCode rc = Dictionary.getInstance().getResultCode(vendorId, code);
                        if (rc == null) {
                            rc = Factory.newResultCode(vendorId, code, "Unknown");
                        }
                        ((DiameterAnswer)message).setResultCode(rc);
                    }
                    if (DiameterSocketConnector.this._listener != null) {
                        DiameterSocketConnector.this._listener.messageReceived(message, this);
                    }
                    DiameterSocketConnector.this.getNode().receive(message);
                }
            }
            catch (EofException e) {
                LOG.debug((Throwable)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
            }
            catch (Throwable t) {
                LOG.warn("handle failed", t);
                try {
                    this.close();
                }
                catch (IOException e2) {
                    LOG.ignore((Throwable)e2);
                }
            }
            finally {
                if (this._peer != null) {
                    this._peer.peerDisc(this);
                }
            }
        }

        @Override
        public void close() throws IOException {
            this._channel.close();
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            try {
                return (InetSocketAddress)this._channel.getLocalAddress();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
                return null;
            }
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            try {
                return (InetSocketAddress)this._channel.getRemoteAddress();
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
                return null;
            }
        }
    }
}

