/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.base;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.net.ntp.TimeStamp;
import org.cipango.diameter.AVP;
import org.cipango.diameter.AVPList;
import org.cipango.diameter.DataFormat;
import org.cipango.diameter.DiameterCommand;
import org.cipango.diameter.Factory;
import org.cipango.diameter.ResultCode;
import org.cipango.diameter.Type;
import org.cipango.diameter.io.Codecs;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Utf8StringBuffer;

public abstract class Common {
    public static final int IETF_VENDOR_ID = 0;
    public static DataFormat<AVPList> __grouped = new DataFormat<AVPList>("Grouped"){

        @Override
        public AVPList decode(ByteBuffer buffer) throws IOException {
            AVPList avps = new AVPList();
            while (buffer.hasRemaining()) {
                AVP<?> avp = Codecs.__avp.decode(buffer);
                avps.add(avp);
            }
            return avps;
        }

        @Override
        public ByteBuffer encode(ByteBuffer buffer, AVPList avps) throws IOException {
            for (AVP avp : avps) {
                buffer = Codecs.__avp.encode(buffer, avp);
            }
            return buffer;
        }
    };
    public static final DataFormat<byte[]> __octetString = new DataFormat<byte[]>("OctetString"){

        @Override
        public byte[] decode(ByteBuffer buffer) throws IOException {
            byte[] out = new byte[buffer.limit() - buffer.position()];
            buffer.get(out);
            return out;
        }

        @Override
        public ByteBuffer encode(ByteBuffer buffer, byte[] value) throws IOException {
            buffer = this.ensureSpace(buffer, value.length);
            buffer.put(value);
            return buffer;
        }
    };
    public static final DataFormat<String> __utf8String = new DataFormat<String>("utf8String"){

        @Override
        public String decode(ByteBuffer buffer) throws IOException {
            byte[] bytes = buffer.array();
            if (bytes != null) {
                return StringUtil.toUTF8String((byte[])bytes, (int)buffer.position(), (int)(buffer.limit() - buffer.position()));
            }
            Utf8StringBuffer b = new Utf8StringBuffer(buffer.limit());
            int i = buffer.position();
            for (int c = 0; c < buffer.limit(); ++c) {
                b.append(buffer.get(i));
                ++i;
            }
            return b.toString();
        }

        @Override
        public ByteBuffer encode(ByteBuffer buffer, String value) throws IOException {
            byte[] bytes = value.getBytes("UTF-8");
            buffer = this.ensureSpace(buffer, bytes.length);
            buffer.put(bytes);
            return buffer;
        }
    };
    public static final DataFormat<InetAddress> __address = new DataFormat<InetAddress>("address"){
        public static final int IPV4 = 1;
        public static final int IPV6 = 2;

        @Override
        public InetAddress decode(ByteBuffer buffer) throws IOException {
            byte[] b;
            int type = (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
            if (type == 1) {
                b = new byte[4];
            } else if (type == 2) {
                b = new byte[16];
            } else {
                throw new IOException("Unknown address type: " + type);
            }
            buffer.get(b, 0, b.length);
            return InetAddress.getByAddress(b);
        }

        @Override
        public ByteBuffer encode(ByteBuffer buffer, InetAddress address) throws IOException {
            int type = address instanceof Inet4Address ? 1 : 2;
            buffer = this.ensureSpace(buffer, 2 + (type == 1 ? 4 : 16));
            buffer.put((byte)0);
            buffer.put((byte)type);
            buffer.put(address.getAddress());
            return buffer;
        }
    };
    public static final DataFormat<Date> __date = new DataFormat<Date>("time"){

        @Override
        public Date decode(ByteBuffer buffer) throws IOException {
            long seconds = 0L;
            for (int i = 0; i < 4; ++i) {
                seconds |= (long)((buffer.get() & 0xFF) << (3 - i) * 8);
            }
            return new Date(TimeStamp.getTime(seconds << 32));
        }

        @Override
        public ByteBuffer encode(ByteBuffer buffer, Date date) throws IOException {
            buffer = this.ensureSpace(buffer, 4);
            byte[] data = new byte[4];
            long nptDate = TimeStamp.getNtpTime(date.getTime()).ntpValue();
            int i = 0;
            int shift = 56;
            while (i < 4) {
                data[i] = (byte)(0xFFL & nptDate >> shift);
                ++i;
                shift -= 8;
            }
            buffer.put(data);
            return buffer;
        }
    };
    public static final DataFormat<Integer> __unsigned32 = new DataFormat<Integer>("unsigned32"){

        @Override
        public Integer decode(ByteBuffer buffer) throws IOException {
            return buffer.getInt();
        }

        @Override
        public ByteBuffer encode(ByteBuffer buffer, Integer value) throws IOException {
            buffer = this.ensureSpace(buffer, 4);
            return buffer.putInt(value);
        }
    };
    public static final int USER_NAME_ORDINAL = 1;
    public static final int AUTH_APPLICATION_ID_ORDINAL = 258;
    public static final int AUTH_SESSION_STATE_ORDINAL = 277;
    public static final int ACCT_APPLICATION_ID_ORDINAL = 259;
    public static final int SESSION_ID_ORDINAL = 263;
    public static final int DESTINATION_HOST_ORDINAL = 293;
    public static final int DESTINATION_REALM_ORDINAL = 283;
    public static final int DISCONNECT_CAUSE_ORDINAL = 273;
    public static final int ORIGIN_HOST_ORDINAL = 264;
    public static final int ORIGIN_REALM_ORDINAL = 296;
    public static final int ORIGIN_STATE_ID_ORDINAL = 278;
    public static final int FIRMWARE_REVISION_ORDINAL = 267;
    public static final int HOST_IP_ADDRESS_ORDINAL = 257;
    public static final int RESULT_CODE_ORDINAL = 268;
    public static final int SUPPORTED_VENDOR_ID_ORDINAL = 265;
    public static final int VENDOR_ID_ORDINAL = 266;
    public static final int VENDOR_SPECIFIC_APPLICATION_ID_ORDINAL = 260;
    public static final int PRODUCT_NAME_ORDINAL = 269;
    public static final int FAILED_AVP_ORDINAL = 279;
    public static final int ERROR_MESSAGE_ORDINAL = 281;
    public static final int ROUTE_RECORD_ORDINAL = 282;
    public static final int REDIRECT_HOST_ORDINAL = 292;
    public static final int ERROR_REPORTING_HOST = 294;
    public static final int EXPERIMENTAL_RESULT_ORDINAL = 297;
    public static final int EXPERIMENTAL_RESULT_CODE_ORDINAL = 298;
    public static final Type<AuthSessionState> AUTH_SESSION_STATE = Common.newEnumType("Auth-Session-State", 277, AuthSessionState.class);
    public static final Type<Integer> AUTH_APPLICATION_ID = Common.newUnsigned32Type("Auth-Application-Id", 258);
    public static final Type<Integer> ACCT_APPLICATION_ID = Common.newUnsigned32Type("Acct-Application-Id", 259);
    public static final Type<String> ORIGIN_HOST = Common.newUTF8StringType("Origin-Host", 264);
    public static final Type<String> ORIGIN_REALM = Common.newUTF8StringType("Origin-Realm", 296);
    public static final Type<String> DESTINATION_REALM = Common.newUTF8StringType("Destination-Realm", 283);
    public static final Type<String> DESTINATION_HOST = Common.newUTF8StringType("Destination-Host", 293);
    public static final Type<String> SESSION_ID = Common.newUTF8StringType("Session-Id", 263);
    public static final Type<String> USER_NAME = Common.newUTF8StringType("User-Name", 1);
    public static final Type<AVPList> VENDOR_SPECIFIC_APPLICATION_ID = Common.newGroupedType("Vendor-Specific-Application-Id", 260);
    public static final Type<Integer> VENDOR_ID = Common.newUnsigned32Type("Vendor-Id", 266);
    public static final Type<String> PRODUCT_NAME = Common.newUTF8StringType("Product-Name", 269).setMandatory(false);
    public static final Type<InetAddress> HOST_IP_ADDRESS = Common.newAddressType("Host-IP-Address", 257);
    public static final Type<DisconnectCause> DISCONNECT_CAUSE = Common.newEnumType("Disconnect-Clause", 273, DisconnectCause.class);
    public static final Type<Integer> RESULT_CODE = Common.newUnsigned32Type("Result-Code", 268);
    public static final Type<AVPList> EXPERIMENTAL_RESULT = Common.newGroupedType("Experimental-Result", 297);
    public static final Type<Integer> EXPERIMENTAL_RESULT_CODE = Common.newUnsigned32Type("Experimental-Result-Code", 298);
    public static Type<Integer> ORIGIN_STATE_ID = Common.newUnsigned32Type("Origin-State-Id", 278);
    public static final Type<Integer> FIRMWARE_REVISION = Common.newUnsigned32Type("Firmware-Revision", 267).setMandatory(false);
    public static final Type<AVPList> FAILED_AVP = Common.newGroupedType("Failed-AVP", 279);
    public static final Type<String> ERROR_MESSAGE_AVP = Common.newUTF8StringType("Error-Message", 281).setMandatory(false);
    public static final Type<String> ROUTE_RECORD_AVP = Common.newUTF8StringType("Route-Record", 282);
    public static final Type<String> ERROR_REPORTING_HOST_AVP = Common.newUTF8StringType("Error-Reporting-Host", 294).setMandatory(false);
    public static final int DIGEST_REALM_ORDINAL = 104;
    public static final int DIGEST_QOP_ORDINAL = 110;
    public static final int DIGEST_ALGORITHM_ORDINAL = 111;
    public static final int DIGEST_HA1_ORDINAL = 121;
    public static final Type<String> DIGEST_REALM = Common.newUTF8StringType("Digest-Realm", 104);
    public static final Type<String> DIGEST_QOP = Common.newUTF8StringType("Digest-Qop", 110);
    public static final Type<String> DIGEST_ALGORITHM = Common.newUTF8StringType("Digest-Algorithm", 111);
    public static final Type<String> DIGEST_HA1 = Common.newUTF8StringType("Digest-HA1", 121);
    public static final int CER_ORDINAL = 257;
    public static final int CEA_ORDINAL = 257;
    public static final int DWR_ORDINAL = 280;
    public static final int DWA_ORDINAL = 280;
    public static final int DPR_ORDINAL = 282;
    public static final int DPA_ORDINAL = 282;
    public static final DiameterCommand CER = Factory.newCommand(true, 257, "Capabilities-Exchange-Request", false);
    public static final DiameterCommand CEA = Factory.newAnswer(257, "Capabilities-Exchange-Answer");
    public static final DiameterCommand DWR = Factory.newRequest(280, "Device-Watchdog-Request");
    public static final DiameterCommand DWA = Factory.newAnswer(280, "Device-Watchdog-Answer");
    public static final DiameterCommand DPR = Factory.newRequest(282, "Disconnect-Peer-Request");
    public static final DiameterCommand DPA = Factory.newAnswer(282, "Disconnect-Peer-Answer");
    public static final Type<Integer> SUPPORTED_VENDOR_ID = Common.newUnsigned32Type("Supported-Vendor-Id", 265);
    public static final Type<String> REDIRECT_HOST = Common.newUTF8StringType("Redirect-Host", 292);
    public static final int DIAMETER_SUCCESS_ORDINAL = 2001;
    public static final int DIAMETER_LIMITED_SUCCESS_ORDINAL = 2002;
    public static final int DIAMETER_COMMAND_UNSUPPORTED_ORDINAL = 3001;
    public static final int DIAMETER_UNABLE_TO_DELIVER_ORDINAL = 3002;
    public static final int DIAMETER_REALM_NOT_SERVED_ORDINAL = 3003;
    public static final int DIAMETER_TOO_BUSY_ORDINAL = 3004;
    public static final int DIAMETER_LOOP_DETECTED_ORDINAL = 3005;
    public static final int DIAMETER_REDIRECT_INDICATION_ORDINAL = 3006;
    public static final int DIAMETER_APPLICATION_UNSUPPORTED_ORDINAL = 3007;
    public static final int DIAMETER_INVALID_HDR_BITS_ORDINAL = 3008;
    public static final int DIAMETER_INVALID_AVP_BITS_ORDINAL = 3009;
    public static final int DIAMETER_UNKNOWN_PEER_ORDINAL = 3010;
    public static final int DIAMETER_AUTHENTICATION_REJECTED_ORDINAL = 4001;
    public static final int DIAMETER_OUT_OF_SPACE_ORDINAL = 4002;
    public static final int ELECTION_LOST_ORDINAL = 4003;
    public static final int DIAMETER_AVP_UNSUPPORTED_ORDINAL = 5001;
    public static final int DIAMETER_UNKNOWN_SESSION_ID_ORDINAL = 5002;
    public static final int DIAMETER_AUTHORIZATION_REJECTED_ORDINAL = 5003;
    public static final int DIAMETER_INVALID_AVP_VALUE_ORDINAL = 5004;
    public static final int DIAMETER_MISSING_AVP_ORDINAL = 5005;
    public static final int DIAMETER_RESOURCES_EXCEEDED_ORDINAL = 5006;
    public static final int DIAMETER_CONTRADICTING_AVPS_ORDINAL = 5007;
    public static final int DIAMETER_AVP_NOT_ALLOWED_ORDINAL = 5008;
    public static final int DIAMETER_AVP_OCCURS_TOO_MANY_TIMES_ORDINAL = 5009;
    public static final int DIAMETER_NO_COMMON_APPLICATION_ORDINAL = 5010;
    public static final int DIAMETER_UNSUPPORTED_VERSION_ORDINAL = 5011;
    public static final int DIAMETER_UNABLE_TO_COMPLY_ORDINAL = 5012;
    public static final int DIAMETER_INVALID_BIT_IN_HEADER_ORDINAL = 5013;
    public static final int DIAMETER_INVALID_AVP_LENGTH_ORDINAL = 5014;
    public static final int DIAMETER_INVALID_MESSAGE_LENGTH_ORDINAL = 5015;
    public static final int DIAMETER_INVALID_AVP_BIT_COMBO_ORDINAL = 5016;
    public static final int DIAMETER_NO_COMMON_SECURITY_ORDINAL = 5017;
    public static final ResultCode DIAMETER_SUCCESS = Factory.newResultCode(2001, "DIAMETER_SUCCESS");
    public static final ResultCode DIAMETER_LIMITED_SUCCESS = Factory.newResultCode(2002, "DIAMETER_LIMITED_SUCCESS");
    public static final ResultCode DIAMETER_COMMAND_UNSUPPORTED = Factory.newResultCode(3001, "DIAMETER_COMMAND_UNSUPPORTED");
    public static final ResultCode DIAMETER_UNABLE_TO_DELIVER = Factory.newResultCode(3002, "DIAMETER_UNABLE_TO_DELIVER");
    public static final ResultCode DIAMETER_REALM_NOT_SERVED = Factory.newResultCode(3003, "DIAMETER_REALM_NOT_SERVED");
    public static final ResultCode DIAMETER_TOO_BUSY = Factory.newResultCode(3004, "DIAMETER_TOO_BUSY");
    public static final ResultCode DIAMETER_LOOP_DETECTED = Factory.newResultCode(3005, "DIAMETER_LOOP_DETECTED");
    public static final ResultCode DIAMETER_REDIRECT_INDICATION = Factory.newResultCode(3006, "DIAMETER_REDIRECT_INDICATION");
    public static final ResultCode DIAMETER_APPLICATION_UNSUPPORTED = Factory.newResultCode(3007, "DIAMETER_APPLICATION_UNSUPPORTED");
    public static final ResultCode DIAMETER_INVALID_HDR_BITS = Factory.newResultCode(3008, "DIAMETER_INVALID_HDR_BITS");
    public static final ResultCode DIAMETER_INVALID_AVP_BITS = Factory.newResultCode(3009, "DIAMETER_INVALID_AVP_BITS");
    public static final ResultCode DIAMETER_UNKNOWN_PEER = Factory.newResultCode(3010, "DIAMETER_UNKNOWN_PEER");
    public static final ResultCode DIAMETER_AUTHENTICATION_REJECTED = Factory.newResultCode(4001, "DIAMETER_AUTHENTICATION_REJECTED");
    public static final ResultCode DIAMETER_OUT_OF_SPACE = Factory.newResultCode(4002, "DIAMETER_OUT_OF_SPACE");
    public static final ResultCode ELECTION_LOST = Factory.newResultCode(4003, "ELECTION_LOST");
    public static final ResultCode DIAMETER_AVP_UNSUPPORTED = Factory.newResultCode(5001, "DIAMETER_AVP_UNSUPPORTED");
    public static final ResultCode DIAMETER_UNKNOWN_SESSION_ID = Factory.newResultCode(5002, "DIAMETER_UNKNOWN_SESSION_ID");
    public static final ResultCode DIAMETER_INVALID_AVP_VALUE = Factory.newResultCode(5004, "DIAMETER_INVALID_AVP_VALUE");
    public static final ResultCode DIAMETER_AUTHORIZATION_REJECTED = Factory.newResultCode(5003, "DIAMETER_AUTHORIZATION_REJECTED");
    public static final ResultCode DIAMETER_MISSING_AVP = Factory.newResultCode(5005, "DIAMETER_MISSING_AVP");
    public static final ResultCode DIAMETER_RESOURCES_EXCEEDED = Factory.newResultCode(5006, "DIAMETER_RESOURCES_EXCEEDED");
    public static final ResultCode DIAMETER_CONTRADICTING_AVPS = Factory.newResultCode(5007, "DIAMETER_CONTRADICTING_AVPS");
    public static final ResultCode DIAMETER_AVP_NOT_ALLOWED = Factory.newResultCode(5008, "DIAMETER_AVP_NOT_ALLOWED");
    public static final ResultCode DIAMETER_AVP_OCCURS_TOO_MANY_TIMES = Factory.newResultCode(5009, "DIAMETER_AVP_OCCURS_TOO_MANY_TIMES");
    public static final ResultCode DIAMETER_NO_COMMON_APPLICATION = Factory.newResultCode(5010, "DIAMETER_NO_COMMON_APPLICATION");
    public static final ResultCode DIAMETER_UNSUPPORTED_VERSION = Factory.newResultCode(5011, "DIAMETER_UNSUPPORTED_VERSION");
    public static final ResultCode DIAMETER_UNABLE_TO_COMPLY = Factory.newResultCode(5012, "DIAMETER_UNABLE_TO_COMPLY");
    public static final ResultCode DIAMETER_INVALID_BIT_IN_HEADER = Factory.newResultCode(5013, "DIAMETER_INVALID_BIT_IN_HEADER");
    public static final ResultCode DIAMETER_INVALID_AVP_LENGTH = Factory.newResultCode(5014, "DIAMETER_INVALID_AVP_LENGTH");
    public static final ResultCode DIAMETER_INVALID_MESSAGE_LENGTH = Factory.newResultCode(5015, "DIAMETER_INVALID_MESSAGE_LENGTH");
    public static final ResultCode DIAMETER_INVALID_AVP_BIT_COMBO = Factory.newResultCode(5016, "DIAMETER_INVALID_AVP_BIT_COMBO");
    public static final ResultCode DIAMETER_NO_COMMON_SECURITY = Factory.newResultCode(5017, "DIAMETER_NO_COMMON_SECURITY");

    public static Type<String> newUTF8StringType(String name, int code) {
        return Factory.newType(name, code, __utf8String);
    }

    public static Type<AVPList> newGroupedType(String name, int code) {
        return Factory.newType(name, code, __grouped);
    }

    public static Type<Integer> newUnsigned32Type(String name, int code) {
        return Factory.newType(name, code, __unsigned32);
    }

    public static Type<InetAddress> newAddressType(String name, int code) {
        return Factory.newType(name, code, __address);
    }

    public static Type<Date> newDateType(String name, int code) {
        return Factory.newType(name, code, __date);
    }

    public static Type<byte[]> newOctetStringType(String name, int code) {
        return Factory.newType(name, code, __octetString);
    }

    public static <T extends Enum<T>> Type<T> newEnumType(String name, int code, Class<T> clazz) {
        return Common.newEnumType(name, 0, code, clazz);
    }

    public static <T extends Enum<T>> Type<T> newEnumType(String name, int vendorId, int code, Class<T> clazz) {
        return Factory.newType(name, vendorId, code, new EnumDataFormat<T>(clazz));
    }

    public static enum DisconnectCause {
        REBOOTING,
        BUSY,
        DO_NOT_WANT_TO_TALK_TO_YOU;

    }

    public static enum AuthSessionState {
        STATE_MAINTAINED,
        NO_STATE_MAINTAINED;

    }

    public static class CustomEnumDataFormat<E extends Enum<E>>
    extends DataFormat<E> {
        private Map<Integer, E> enums = new HashMap<Integer, E>();

        public CustomEnumDataFormat(Class<E> clazz) {
            super("Enumerated " + clazz.getSimpleName());
            EnumSet<Enum> values = EnumSet.allOf(clazz);
            for (Enum e : values) {
                this.enums.put(((CustomEnumValues)((Object)e)).getValue(), e);
            }
        }

        @Override
        public E decode(ByteBuffer buffer) throws IOException {
            int i = (Integer)__unsigned32.decode(buffer);
            return (E)((Enum)this.enums.get(i));
        }

        @Override
        public ByteBuffer encode(ByteBuffer buffer, E value) throws IOException {
            return __unsigned32.encode(buffer, ((CustomEnumValues)value).getValue());
        }
    }

    public static interface CustomEnumValues {
        public int getValue();
    }

    public static class EnumDataFormat<E extends Enum<E>>
    extends DataFormat<E> {
        private E[] enums;
        private int _offset;

        public EnumDataFormat(Class<E> clazz) {
            super("Enumerated " + clazz.getSimpleName());
            EnumSet<E> values = EnumSet.allOf(clazz);
            this.enums = (Enum[])Array.newInstance(clazz, values.size());
            values.toArray(this.enums);
        }

        public EnumDataFormat(Class<E> clazz, int offset) {
            this(clazz);
            this._offset = offset;
        }

        @Override
        public E decode(ByteBuffer buffer) throws IOException {
            int i = (Integer)__unsigned32.decode(buffer);
            return this.enums[i - this._offset];
        }

        @Override
        public ByteBuffer encode(ByteBuffer buffer, E value) throws IOException {
            return __unsigned32.encode(buffer, ((Enum)value).ordinal() + this._offset);
        }
    }
}

