/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.app;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cipango.diameter.api.DiameterErrorEvent;
import org.cipango.diameter.api.DiameterErrorListener;
import org.cipango.diameter.api.DiameterListener;
import org.cipango.diameter.api.DiameterServletMessage;
import org.cipango.diameter.app.DiameterAppContext;
import org.cipango.diameter.node.DiameterAnswer;
import org.cipango.diameter.node.DiameterHandler;
import org.cipango.diameter.node.DiameterMessage;
import org.cipango.diameter.node.DiameterRequest;
import org.cipango.diameter.node.TimeoutHandler;
import org.cipango.server.session.SessionManager;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.WebAppContext;

public class DiameterContext
implements DiameterHandler,
TimeoutHandler {
    private static final Logger LOG = Log.getLogger(DiameterContext.class);
    private SipAppContext _defaultContext;
    private Map<String, DiameterAppContext> _diameterListeners = new ConcurrentHashMap<String, DiameterAppContext>();
    private Method _handleMsg;
    private Method _noAnswerReceived;

    public DiameterContext() {
        try {
            this._handleMsg = DiameterListener.class.getMethod("handle", DiameterServletMessage.class);
            this._noAnswerReceived = DiameterErrorListener.class.getMethod("noAnswerReceived", DiameterErrorEvent.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public void addListeners(WebAppContext context, DiameterListener[] listeners, DiameterErrorListener[] errorListeners) {
        this._diameterListeners.put(context.getContextPath(), new DiameterAppContext(listeners, errorListeners));
        if (this._defaultContext == null) {
            this._defaultContext = (SipAppContext)context.getBean(SipAppContext.class);
        }
    }

    public void addListener(WebAppContext context, DiameterListener listener) {
        DiameterAppContext diameterAppContext = this._diameterListeners.get(context.getContextPath());
        if (diameterAppContext == null) {
            diameterAppContext = new DiameterAppContext();
            this._diameterListeners.put(context.getContextPath(), diameterAppContext);
        }
        diameterAppContext.addDiameterListener(listener);
        if (this._defaultContext == null) {
            this._defaultContext = (SipAppContext)context.getBean(SipAppContext.class);
        }
    }

    public void removeListener(WebAppContext context, DiameterListener listener) {
        DiameterAppContext diameterAppContext = this._diameterListeners.get(context.getContextPath());
        if (diameterAppContext == null) {
            return;
        }
        diameterAppContext.removeDiameterListener(listener);
    }

    public void addErrorListener(WebAppContext context, DiameterErrorListener listener) {
        DiameterAppContext diameterAppContext = this._diameterListeners.get(context.getContextPath());
        if (diameterAppContext == null) {
            diameterAppContext = new DiameterAppContext();
            this._diameterListeners.put(context.getContextPath(), diameterAppContext);
        }
        diameterAppContext.addErrorListener(listener);
        if (this._defaultContext == null) {
            this._defaultContext = (SipAppContext)context.getBean(SipAppContext.class);
        }
    }

    public void removeErrorListener(WebAppContext context, DiameterErrorListener listener) {
        DiameterAppContext diameterAppContext = this._diameterListeners.get(context.getContextPath());
        if (diameterAppContext == null) {
            return;
        }
        diameterAppContext.removeErrorListener(listener);
    }

    public void removeListeners(WebAppContext context) {
        this._diameterListeners.remove(context.getContextPath());
        if (this._defaultContext == context.getBean(SipAppContext.class)) {
            this._defaultContext = null;
        }
    }

    @Override
    public void handle(DiameterMessage message) throws IOException {
        DiameterAppContext ctx;
        List<DiameterListener> listeners = null;
        SipAppContext context = null;
        if (message instanceof DiameterAnswer) {
            context = ((DiameterAnswer)message).getRequest().getContext();
        }
        SessionManager.AppSessionIf appSession = (SessionManager.AppSessionIf)message.getApplicationSession();
        if (context == null && appSession != null) {
            context = appSession.getAppSession().getContext();
        }
        if (context == null) {
            context = this._defaultContext;
        }
        if (context != null && (ctx = this._diameterListeners.get(context.getWebAppContext().getContextPath())) != null) {
            listeners = ctx.getDiameterListeners();
        }
        if (listeners != null && !listeners.isEmpty()) {
            context.fire(appSession == null ? null : appSession.getAppSession(), listeners, this._handleMsg, new Object[]{message});
        } else {
            LOG.warn("No diameter listeners for context {} to handle message {}", new Object[]{context == null ? "" : context.getName(), message});
        }
    }

    @Override
    public void fireNoAnswerReceived(DiameterRequest request, long timeout) {
        DiameterAppContext ctx;
        List<DiameterErrorListener> listeners = null;
        SipAppContext context = request.getContext();
        SessionManager.AppSessionIf appSession = (SessionManager.AppSessionIf)request.getApplicationSession();
        if (context == null && appSession != null) {
            context = appSession.getAppSession().getContext();
        }
        if (context == null) {
            context = this._defaultContext;
            LOG.debug("Use default context {} to handle timeout for {}", new Object[]{context == null ? "" : context.getName(), request});
        }
        if (context != null && (ctx = this._diameterListeners.get(context.getWebAppContext().getContextPath())) != null) {
            listeners = ctx.getErrorListeners();
        }
        if (listeners != null && !listeners.isEmpty()) {
            context.fire(appSession == null ? null : appSession.getAppSession(), listeners, this._noAnswerReceived, new Object[]{new DiameterErrorEvent(request, timeout)});
        } else {
            LOG.warn("Could not notify timeout for diameter request {} as no listeners defined for context {}", new Object[]{request, context == null ? "" : context.getName()});
        }
    }
}

