/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.app;

import org.cipango.diameter.api.DiameterFactory;
import org.cipango.diameter.app.DiameterContext;
import org.cipango.diameter.app.DiameterDecorator;
import org.cipango.diameter.node.DiameterFactoryImpl;
import org.cipango.diameter.node.Node;
import org.cipango.server.sipapp.SipAppContext;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;

public class DiameterConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(DiameterConfiguration.class);

    public void preConfigure(WebAppContext context) throws Exception {
        if (context.isStarted()) {
            LOG.debug("Cannot configure webapp after it is started", new Object[0]);
            return;
        }
        DiameterFactoryImpl factory = new DiameterFactoryImpl();
        Node node = (Node)context.getServer().getBean(Node.class);
        factory.setNode(node);
        factory.setAppContext((SipAppContext)context.getBean(SipAppContext.class));
        context.setAttribute(DiameterFactory.class.getName(), (Object)factory);
        context.addDecorator((ServletContextHandler.Decorator)new DiameterDecorator((DiameterContext)node.getHandler(), context));
    }

    public void deconfigure(WebAppContext context) throws Exception {
        Node node = (Node)context.getServer().getBean(Node.class);
        ((DiameterContext)node.getHandler()).removeListeners(context);
    }
}

