/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter.app;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.cipango.diameter.api.DiameterErrorListener;
import org.cipango.diameter.api.DiameterListener;

class DiameterAppContext {
    private final List<DiameterListener> _diameterListeners = new CopyOnWriteArrayList<DiameterListener>();
    private final List<DiameterErrorListener> _errorListeners = new CopyOnWriteArrayList<DiameterErrorListener>();

    public DiameterAppContext() {
    }

    public DiameterAppContext(DiameterListener[] listeners, DiameterErrorListener[] errorListeners) {
        this._diameterListeners.addAll(Arrays.asList(listeners));
        this._errorListeners.addAll(Arrays.asList(errorListeners));
    }

    public void addDiameterListener(DiameterListener l) {
        this._diameterListeners.add(l);
    }

    public void removeDiameterListener(DiameterListener l) {
        this._diameterListeners.remove(l);
    }

    public void addErrorListener(DiameterErrorListener l) {
        this._errorListeners.add(l);
    }

    public void removeErrorListener(DiameterErrorListener l) {
        this._errorListeners.remove(l);
    }

    public List<DiameterListener> getDiameterListeners() {
        return this._diameterListeners;
    }

    public List<DiameterErrorListener> getErrorListeners() {
        return this._errorListeners;
    }
}

