/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter;

import org.cipango.diameter.AVP;
import org.cipango.diameter.AVPList;
import org.cipango.diameter.base.Common;

public class ResultCode {
    private int _vendorId;
    private int _code;
    private String _name;

    public ResultCode(int vendorId, int code, String name) {
        this._code = code;
        this._name = name;
        this._vendorId = vendorId;
    }

    public int getCode() {
        return this._code;
    }

    public String getName() {
        return this._name;
    }

    public boolean isInformational() {
        return this._code / 1000 == 1;
    }

    public boolean isSuccess() {
        return this._code / 1000 == 2;
    }

    public boolean isProtocolError() {
        return this._code / 1000 == 3;
    }

    public boolean isTransientFailure() {
        return this._code / 1000 == 4;
    }

    public boolean isPermanentFailure() {
        return this._code / 1000 == 5;
    }

    public int getVendorId() {
        return this._vendorId;
    }

    public boolean isExperimentalResultCode() {
        return this._vendorId != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._name != null) {
            sb.append(this._name).append(' ');
        }
        sb.append("(").append(this._vendorId).append('/').append(this._code).append(")");
        return sb.toString();
    }

    public AVP<?> getAVP() {
        if (this._vendorId == 0) {
            return new AVP<Integer>(Common.RESULT_CODE, this._code);
        }
        AVPList expRc = new AVPList();
        expRc.add(Common.VENDOR_ID, this._vendorId);
        expRc.add(Common.EXPERIMENTAL_RESULT_CODE, this._code);
        return new AVP<AVPList>(Common.EXPERIMENTAL_RESULT, expRc);
    }
}

