/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.cipango.diameter.DiameterCommand;
import org.cipango.diameter.ResultCode;
import org.cipango.diameter.Type;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Dictionary {
    private static final Logger LOG = Log.getLogger(Dictionary.class);
    private static final Dictionary __dictionary = new Dictionary();
    private Map<Long, Type<?>> _types = new HashMap();
    private Map<Integer, DiameterCommand> _requests = new HashMap<Integer, DiameterCommand>();
    private Map<Integer, DiameterCommand> _answers = new HashMap<Integer, DiameterCommand>();
    private Map<Long, ResultCode> _resultCodes = new HashMap<Long, ResultCode>();

    public static Dictionary getInstance() {
        return __dictionary;
    }

    public DiameterCommand getRequest(int code) {
        return this._requests.get(code);
    }

    public DiameterCommand getAnswer(int code) {
        return this._answers.get(code);
    }

    public Type<?> getType(int vendorId, int code) {
        return this._types.get(this.id(vendorId, code));
    }

    public ResultCode getResultCode(int vendorId, int code) {
        return this._resultCodes.get(this.id(vendorId, code));
    }

    public void load(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if ((field.getModifiers() & 8) != 8) continue;
            try {
                if (Type.class.isAssignableFrom(field.getType())) {
                    Type type = (Type)field.get(null);
                    LOG.debug("Loaded type: " + type, new Object[0]);
                    this._types.put(this.id(type.getVendorId(), type.getCode()), type);
                    continue;
                }
                if (DiameterCommand.class.isAssignableFrom(field.getType())) {
                    DiameterCommand command = (DiameterCommand)field.get(null);
                    LOG.debug("Loaded command: " + command, new Object[0]);
                    if (command.isRequest()) {
                        this._requests.put(command.getCode(), command);
                        continue;
                    }
                    this._answers.put(command.getCode(), command);
                    continue;
                }
                if (!ResultCode.class.isAssignableFrom(field.getType())) continue;
                ResultCode rc = (ResultCode)field.get(null);
                LOG.debug("Loaded result code: " + rc, new Object[0]);
                this._resultCodes.put(this.id(rc.getVendorId(), rc.getCode()), rc);
                continue;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    public long id(int vendorId, int code) {
        return (long)vendorId << 32 | (long)code;
    }
}

