/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.cipango.diameter.AVP;
import org.cipango.diameter.AVPList;
import org.cipango.diameter.api.DiameterServletMessage;
import org.cipango.diameter.base.Common;

public class ApplicationId {
    private int _id;
    private Type _type;
    private List<Integer> _vendors;

    public ApplicationId(Type type, int id, List<Integer> vendors) {
        this._id = id;
        this._type = type;
        this._vendors = vendors;
    }

    public ApplicationId(Type type, int id, int vendor) {
        this(type, id, Collections.singletonList(vendor));
    }

    public ApplicationId(Type type, int id) {
        this(type, id, null);
    }

    public int getId() {
        return this._id;
    }

    public boolean isAuth() {
        return this._type == Type.Auth;
    }

    public boolean isAcct() {
        return this._type == Type.Acct;
    }

    public boolean isVendorSpecific() {
        return this._vendors != null && this._vendors.size() != 0;
    }

    public List<Integer> getVendors() {
        return this._vendors;
    }

    public AVP<?> getAVP() {
        AVP<Integer> appId = this._type == Type.Auth ? new AVP<Integer>(Common.AUTH_APPLICATION_ID, this._id) : new AVP<Integer>(Common.ACCT_APPLICATION_ID, this._id);
        if (this._vendors != null && this._vendors.size() > 0) {
            AVP<AVPList> vsai = new AVP<AVPList>(Common.VENDOR_SPECIFIC_APPLICATION_ID, new AVPList());
            for (Integer vendorId : this._vendors) {
                vsai.getValue().add(Common.VENDOR_ID, vendorId);
            }
            vsai.getValue().add(appId);
            return vsai;
        }
        return appId;
    }

    public boolean equals(Object o) {
        boolean same;
        if (!(o instanceof ApplicationId)) {
            return false;
        }
        ApplicationId other = (ApplicationId)o;
        boolean bl = same = this._id == other.getId() && this._type == other._type && this.isVendorSpecific() == other.isVendorSpecific();
        if (this.isVendorSpecific()) {
            return same && this.getVendors().equals(other.getVendors());
        }
        return same;
    }

    public String toString() {
        return this._id + (this.isVendorSpecific() ? this._vendors.toString() : "");
    }

    public static ApplicationId ofAVP(DiameterServletMessage message) {
        Integer appId = message.get(Common.ACCT_APPLICATION_ID);
        if (appId != null) {
            return new ApplicationId(Type.Acct, appId);
        }
        appId = message.get(Common.AUTH_APPLICATION_ID);
        if (appId != null) {
            return new ApplicationId(Type.Auth, appId);
        }
        AVPList list = message.get(Common.VENDOR_SPECIFIC_APPLICATION_ID);
        if (list == null) {
            return null;
        }
        ArrayList<Integer> vendors = new ArrayList<Integer>();
        Iterator<AVP<Integer>> it = list.getAVPs(Common.VENDOR_ID);
        while (it.hasNext()) {
            vendors.add(it.next().getValue());
        }
        appId = list.getValue(Common.ACCT_APPLICATION_ID);
        if (appId != null) {
            return new ApplicationId(Type.Acct, (int)appId, vendors);
        }
        appId = list.getValue(Common.AUTH_APPLICATION_ID);
        return new ApplicationId(Type.Auth, (int)appId, vendors);
    }

    public static enum Type {
        Acct,
        Auth;

    }
}

