/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.diameter;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.cipango.diameter.AVP;
import org.cipango.diameter.Type;
import org.eclipse.jetty.util.LazyList;

public class AVPList
extends AbstractList<AVP<?>> {
    private ArrayList<AVP<?>> _avps = new ArrayList();

    public <T> AVP<T> get(Type<T> type) {
        for (AVP<?> avp : this._avps) {
            if (avp.getType() != type) continue;
            return avp;
        }
        return null;
    }

    public <T> T getValue(Type<T> type) {
        AVP<T> avp = this.get(type);
        if (avp == null) {
            return null;
        }
        return avp.getValue();
    }

    @Override
    public void add(int index, AVP<?> avp) {
        this._avps.add(index, avp);
    }

    public <T> void add(Type<T> type, T value) {
        AVP<T> avp = new AVP<T>(type);
        avp.setValue(value);
        this.add(avp);
    }

    @Override
    public AVP<?> get(int index) {
        return this._avps.get(index);
    }

    @Override
    public int size() {
        return this._avps.size();
    }

    public <T> Iterator<AVP<T>> getAVPs(Type<T> type) {
        Object avps = null;
        for (int i = 0; i < this._avps.size(); ++i) {
            AVP<?> avp = this._avps.get(i);
            if (avp.getType() != type) continue;
            avps = LazyList.add(avps, avp);
        }
        return LazyList.iterator(avps);
    }
}

