/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip.labs;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import javax.servlet.sip.SipURI;
import org.cipango.sip.SipScheme;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.UrlEncoded;

public class SipURIImpl2
implements SipURI {
    private static final StringMap CACHE = new StringMap(true);
    private boolean _secure = false;
    private String _user;
    private String _password;
    private String _host;
    private int _port = -1;
    private EnumMap<Param, String> _params;

    public SipURIImpl2(String uri) throws ParseException {
        this.parse(uri);
    }

    public SipURIImpl2() {
    }

    public boolean isSipURI() {
        return true;
    }

    public String getScheme() {
        return this._secure ? SipScheme.SIPS.toString() : SipScheme.SIP.toString();
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void setSecure(boolean b) {
        this._secure = b;
    }

    public String getUser() {
        return this._user;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        if (port < 0) {
            port = -1;
        }
        this._port = port;
    }

    public String getUserPassword() {
        return this._password;
    }

    public void setUserPassword(String password) {
        this._password = password;
    }

    public void parse(String uri) throws ParseException {
        int host;
        int port;
        int user;
        int passwd;
        State state;
        int i = 0;
        int e = uri.length();
        if (uri.startsWith("sip:")) {
            i = 4;
        } else if (uri.startsWith("sips:")) {
            this._secure = true;
            i = 5;
        } else {
            throw new ParseException("invalid scheme", 0);
        }
        int params = e;
        int headers = e;
        if (uri.indexOf(64) != -1) {
            state = State.USER;
            user = passwd = i;
            host = port = e;
        } else {
            state = State.HOST;
            host = i;
            passwd = port = e;
            user = port;
        }
        block10: while (i < e) {
            char c = uri.charAt(i);
            int s = i++;
            switch (state) {
                case USER: {
                    switch (c) {
                        case ':': {
                            passwd = s;
                            state = State.PASSWORD;
                            break;
                        }
                        case '@': {
                            passwd = s;
                            host = i;
                            state = State.HOST;
                        }
                    }
                    continue block10;
                }
                case PASSWORD: {
                    if (c != '@') continue block10;
                    host = i;
                    state = State.HOST;
                    continue block10;
                }
                case HOST: {
                    if (c == ':') {
                        state = State.PORT;
                        port = s;
                        continue block10;
                    }
                    if (c != ';') continue block10;
                    params = s;
                    state = State.PARAMETERS;
                    continue block10;
                }
                case PORT: {
                    if (c != ';') continue block10;
                    params = s;
                    state = State.PARAMETERS;
                    continue block10;
                }
            }
        }
        if (user < passwd) {
            this._user = uri.substring(user, passwd);
        }
        if (passwd < host - 2) {
            this._password = uri.substring(passwd + 1, host - 1);
        }
        if (port <= host) {
            throw new ParseException("missing host", port);
        }
        this._host = uri.substring(host, port);
        if (port < params) {
            this._port = TypeUtil.parseInt((String)uri, (int)(port + 1), (int)(params - port - 1), (int)10);
        }
        if (params < headers) {
            this.parseParams(uri, params + 1);
        }
    }

    protected void parseParams(String s, int offset) {
        String key = null;
        String value = null;
        int m = offset - 1;
        block4: for (int i = offset; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case ';': {
                    int l = i - m - 1;
                    value = l == 0 ? "" : s.substring(m + 1, i);
                    m = i;
                    if (key != null) {
                        System.out.println(key + "  =   " + value);
                    } else if (value != null && value.length() > 0) {
                        System.out.println(value);
                    }
                    value = null;
                    key = null;
                    continue block4;
                }
                case '=': {
                    if (key != null) continue block4;
                    key = s.substring(m + 1, i);
                    m = i;
                }
            }
        }
        if (key != null) {
            int l = s.length() - m - 1;
            value = l == 0 ? "" : s.substring(m + 1);
            System.out.println(key + "=" + value);
        } else if (m < s.length() && (key = s.substring(m + 1)) != null && key.length() > 0) {
            System.out.println(key);
        }
    }

    public static void main(String[] args) throws Exception {
        String s = "Fran%c3%a7ois";
        System.out.println(UrlEncoded.decodeString((String)s, (int)0, (int)s.length(), null));
    }

    private String getParameter(Param name) {
        if (this._params == null) {
            return null;
        }
        return this._params.get((Object)name);
    }

    private synchronized void setParameter(Param name, String value) {
        if (this._params == null) {
            this._params = new EnumMap(Param.class);
        }
        this._params.put(name, value);
    }

    private void removeParameter(Param name) {
        if (this._params != null) {
            this._params.remove((Object)name);
        }
    }

    public String getParameter(String name) {
        Param param = (Param)((Object)CACHE.get(name));
        if (param != null) {
            return this.getParameter(param);
        }
        return null;
    }

    public Iterator<String> getParameterNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (this._params != null) {
            for (Param param : this._params.keySet()) {
                list.add(param.toString());
            }
        }
        return list.iterator();
    }

    public void removeParameter(String name) {
    }

    public void setParameter(String name, String value) {
        Param param = (Param)((Object)CACHE.get(name));
        if (param != null) {
            this.setParameter(param, value);
        }
    }

    public boolean getLrParam() {
        return "".equals(this.getParameter(Param.LR));
    }

    public String getMAddrParam() {
        return this.getParameter(Param.MADDR);
    }

    public String getMethodParam() {
        return this.getParameter(Param.METHOD);
    }

    public int getTTLParam() {
        String s = this.getParameter(Param.TTL);
        return s != null ? Integer.parseInt(s) : -1;
    }

    public String getTransportParam() {
        return this.getParameter(Param.TRANSPORT);
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public void setLrParam(boolean b) {
        if (b) {
            this.setParameter(Param.LR, "");
        } else {
            this.removeParameter(Param.LR);
        }
    }

    public String getUserParam() {
        return this.getParameter(Param.USER);
    }

    public void removeHeader(String arg0) {
    }

    public void setHeader(String arg0, String arg1) {
    }

    public void setMAddrParam(String arg0) {
    }

    public void setMethodParam(String arg0) {
    }

    public void setTTLParam(int arg0) {
    }

    public void setTransportParam(String transport) {
        this.setParameter(Param.TRANSPORT, transport);
    }

    public void setUserParam(String arg0) {
    }

    public String getHeader(String arg0) {
        return null;
    }

    public Iterator<String> getHeaderNames() {
        return null;
    }

    public SipURIImpl2 clone() {
        try {
            return (SipURIImpl2)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        for (Param param : Param.values()) {
            CACHE.put(param.toString(), (Object)param);
        }
    }

    static enum Host {
        IPV4,
        NAME,
        IPV6;

    }

    static enum State {
        USER,
        PASSWORD,
        HOST,
        PORT,
        PARAMETERS,
        HEADERS;

    }

    static enum Param {
        TRANSPORT,
        TTL,
        MADDR,
        METHOD,
        USER,
        LR;

    }
}

