/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip.labs;

import java.util.Random;
import org.eclipse.jetty.util.TypeUtil;

public class HexString {
    private static final char[] __hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] __hexCharsUC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void appendHex(StringBuffer buf, int c) {
        buf.append(__hexCharsUC[(c & 0xF0) >> 4]);
        buf.append(__hexCharsUC[c & 0xF]);
    }

    public static String toHexString(String s) {
        return HexString.toHexString(s.getBytes());
    }

    public static String toHexString(byte[] buffer) {
        return HexString.toHexString(buffer, 0, buffer.length);
    }

    public static String toHexString(byte[] b, int offset, int length) {
        StringBuffer hex = new StringBuffer(2 * length);
        for (int i = offset; i < offset + length; ++i) {
            hex.append(__hexChars[(b[i] & 0xF0) >> 4]);
            hex.append(__hexChars[b[i] & 0xF]);
        }
        return hex.toString();
    }

    public static byte[] fromHexString(String hex) throws NumberFormatException {
        int length = hex.length();
        byte[] buf = new byte[(length + 1) / 2];
        boolean even = true;
        byte b = 0;
        int offset = 0;
        if (length % 2 == 1) {
            even = false;
        }
        for (int i = 0; i < length; ++i) {
            int nibble;
            char c = hex.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new NumberFormatException("Invalid hex digit '" + c + "'.");
            }
            if (even) {
                b = (byte)(nibble << 4);
            } else {
                b = (byte)(b + (byte)nibble);
                buf[offset++] = b;
            }
            even = !even;
        }
        return buf;
    }

    public static String toDetailedHexString(byte[] b, int length) {
        StringBuffer sb = new StringBuffer(5 * length);
        int lines = (length >>> 4) + 1;
        for (int i = 0; i < lines; ++i) {
            int c;
            int j;
            sb.append(__hexChars[(i >>> 4 & 0xF0) >> 4]);
            sb.append(__hexChars[i >>> 4 & 0xF]);
            sb.append(__hexChars[(i << 4 & 0xF0) >> 4]);
            sb.append(__hexChars[i << 4 & 0xF]);
            sb.append(' ');
            int n = i == lines - 1 ? length & 0xF : 16;
            for (j = 0; j < 16; ++j) {
                if (j < n) {
                    c = b[i * 16 + j];
                    sb.append(__hexChars[(c & 0xF0) >> 4]);
                    sb.append(__hexChars[c & 0xF]);
                    sb.append(' ');
                    continue;
                }
                sb.append("   ");
            }
            for (j = 0; j < n; ++j) {
                c = b[i * 16 + j] & 0xFF;
                if (c > 31 && c < 127) {
                    sb.append((char)c);
                    continue;
                }
                sb.append('.');
            }
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        byte[] b = new byte[16];
        Random random = new Random();
        random.nextBytes(b);
        System.out.println(HexString.toHexString(b));
        System.out.println(TypeUtil.toString((byte[])b, (int)16));
    }
}

