/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.BitSet;
import java.util.EnumMap;
import javax.servlet.sip.Parameterable;
import org.cipango.sip.Parameters;
import org.cipango.util.StringScanner;
import org.cipango.util.StringUtil;
import org.eclipse.jetty.util.StringMap;

public class Via
extends Parameters
implements Parameterable,
Serializable {
    private static final long serialVersionUID = 1L;
    static StringMap<Param> CACHE = new StringMap(true);
    public static final String MAGIC_COOKIE = "z9hG4bK";
    private String _string;
    private String _transport;
    private String _host;
    private int _port = -1;
    private EnumMap<Param, String> _params = new EnumMap(Param.class);
    private static final BitSet END_HOST;

    public Via(String via) {
        this._string = via;
    }

    public Via(String host, String transport, int port) {
        this._host = host;
        this._transport = transport;
        this._port = port;
    }

    public String getTransport() {
        return this._transport;
    }

    public int getPort() {
        return this._port;
    }

    public String getHost() {
        return this._host;
    }

    public String getBranch() {
        return this._params.get((Object)Param.BRANCH);
    }

    public String getReceived() {
        return this._params.get((Object)Param.RECEIVED);
    }

    public void setReceived(String received) {
        this._params.put(Param.RECEIVED, received);
    }

    public void setBranch(String branch) {
        this._params.put(Param.BRANCH, branch);
    }

    public int getRPort() {
        String s = this._params.get((Object)Param.RPORT);
        return s != null && s.length() > 0 ? Integer.parseInt(s) : -1;
    }

    public boolean hasRPort() {
        return this._params.get((Object)Param.RPORT) != null;
    }

    public void setRPort(int port) {
        this._params.put(Param.RPORT, Integer.toString(port));
    }

    public String getMAddr() {
        return this._params.get((Object)Param.MADDR);
    }

    public boolean hasMAddr() {
        return this._params.get((Object)Param.MADDR) != null;
    }

    public void setMAddr(String maddr) {
        this._params.put(Param.MADDR, maddr);
    }

    @Override
    public void setParameter(String name, String value) {
        Param param = (Param)((Object)CACHE.get(name));
        if (param != null) {
            this._params.put(param, value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    public void parameterParsed(String name, String value) {
        this.setParameter(name, value);
    }

    @Override
    public String getParameter(String name) {
        Param param = (Param)((Object)CACHE.get(name));
        if (param != null) {
            return this._params.get((Object)param);
        }
        return super.getParameter(name);
    }

    public void parse() throws ParseException {
        StringScanner scanner = new StringScanner(this._string);
        scanner.skipToChar('/').readChar('/');
        scanner.skipToChar('/').readChar('/').skipWhitespace();
        this._transport = scanner.readToSpace();
        scanner.skipWhitespace();
        if (scanner.peekChar() == '[') {
            scanner.skipChar().mark().skipToChar(']');
            this._host = scanner.readFromMark();
            scanner.readChar(']');
        } else {
            this._host = scanner.readTo(END_HOST);
        }
        if (!scanner.eof() && scanner.peekChar() == ':') {
            this._port = scanner.skipChar().readInt();
        }
        scanner.skipToChar(';');
        this.parseParameters(scanner);
    }

    public String getValue() {
        return this.getValueBuffer().toString();
    }

    public void setValue(String value) {
        throw new UnsupportedOperationException();
    }

    public StringBuilder getValueBuffer() {
        boolean ipv6Addr;
        StringBuilder buffer = new StringBuilder();
        buffer.append("SIP/2.0/");
        buffer.append(this._transport);
        buffer.append(' ');
        boolean bl = ipv6Addr = this._host.indexOf(58) != -1 && this._host.indexOf(91) == -1;
        if (ipv6Addr) {
            buffer.append("[");
        }
        buffer.append(this._host);
        if (ipv6Addr) {
            buffer.append("]");
        }
        if (this._port > -1) {
            buffer.append(':');
            buffer.append(this._port);
        }
        return buffer;
    }

    public String toString() {
        StringBuilder buffer = this.getValueBuffer();
        for (Param p : Param.values()) {
            String value = this._params.get((Object)p);
            if (value == null) continue;
            buffer.append(';');
            buffer.append(p.toString());
            if ("".equals(value)) continue;
            buffer.append('=');
            buffer.append(value);
        }
        this.appendParameters(buffer);
        return buffer.toString();
    }

    @Override
    public Via clone() {
        try {
            Via via = (Via)super.clone();
            via._params = this._params.clone();
            return via;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTransport(String transport) {
        this._transport = transport;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this._port = -1;
            this._params = new EnumMap(Param.class);
            this._string = in.readUTF();
            this.parse();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Via)) {
            return false;
        }
        return obj.toString().equals(this.toString());
    }

    static {
        for (Param p : Param.values()) {
            CACHE.put(p.toString(), (Object)p);
        }
        END_HOST = StringUtil.toBitSet((String)":; \t");
    }

    static enum Param {
        BRANCH("branch"),
        RECEIVED("received"),
        RPORT("rport"),
        MADDR("maddr"),
        ALIAS("alias"),
        COMP("comp"),
        KEEP("keep"),
        SIGCOMPID("sigcomp-id"),
        TTL("ttl");

        private String _string;

        private Param(String s) {
            this._string = s;
        }

        public String toString() {
            return this._string;
        }
    }
}

