/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.sip.URI;
import org.cipango.sip.Modifiable;
import org.cipango.util.StringUtil;

public class URIImpl
implements URI,
Serializable,
Modifiable {
    private static final long serialVersionUID = 1L;
    private static final BitSet ALPHA_BS = StringUtil.toBitSet((String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    private static final BitSet SCHEME_BS = StringUtil.toBitSet((String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+-.");
    private String _uri;
    private String _scheme;
    private String _file;
    private HashMap<String, String> _params = new HashMap();
    private transient boolean _modified;

    protected URIImpl() {
    }

    public URIImpl(String uri) throws ParseException {
        this._uri = uri;
        this.parse();
        this._modified = false;
    }

    private void parse() throws ParseException {
        int indexScheme = this._uri.indexOf(58);
        if (indexScheme < 0) {
            throw new ParseException("Missing scheme in uri [" + this._uri + "]", 0);
        }
        this._scheme = this._uri.substring(0, indexScheme);
        if (!URIImpl.isURIScheme(this._scheme)) {
            throw new ParseException("Invalid scheme [" + this._scheme + "] in uri [" + this._uri + "]", 0);
        }
        int indexParam = this._uri.indexOf(59, indexScheme);
        if (indexParam < 0) {
            this._file = this._uri.substring(indexScheme + 1);
        } else {
            this._file = this._uri.substring(indexScheme + 1, indexParam);
            String sParams = this._uri.substring(indexParam + 1);
            this.parseParams(sParams);
        }
    }

    public static final boolean isURIScheme(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (!ALPHA_BS.get(s.charAt(0))) {
            return false;
        }
        return StringUtil.contains((String)s, (BitSet)SCHEME_BS);
    }

    private void parseParams(String sParams) throws ParseException {
        StringTokenizer st = new StringTokenizer(sParams, ";");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String param = st.nextToken();
            int index = param.indexOf(61);
            if (index < 0) {
                name = param.trim();
                value = "";
            } else {
                name = param.substring(0, index).trim();
                value = param.substring(index + 1).trim();
            }
            this._params.put(StringUtil.unescape((String)name.toLowerCase()), StringUtil.unescape((String)value));
        }
    }

    public boolean isSipURI() {
        return false;
    }

    public String getScheme() {
        return this._scheme;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof URI)) {
            return false;
        }
        URI uri = (URI)o;
        if (!this._scheme.equals(uri.getScheme())) {
            return false;
        }
        return this.toString().equalsIgnoreCase(uri.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public URI clone() {
        try {
            URIImpl uri = (URIImpl)super.clone();
            if (this._params != null) {
                uri._params = (HashMap)this._params.clone();
            }
            return uri;
        }
        catch (CloneNotSupportedException _) {
            throw new RuntimeException();
        }
    }

    public String toString() {
        if (this._uri != null) {
            return this._uri;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._scheme).append(":");
        sb.append(this._file);
        Iterator<String> it = this.getParameterNames();
        while (it.hasNext()) {
            String name = it.next();
            String value = this.getParameter(name);
            sb.append(';');
            sb.append(StringUtil.encode((String)name, (BitSet)StringUtil.PARAM_BS));
            if (value == null || value.length() <= 0) continue;
            sb.append('=');
            sb.append(StringUtil.encode((String)value, (BitSet)StringUtil.PARAM_BS));
        }
        return sb.toString();
    }

    public String getParameter(String name) {
        return this._params.get(name.toLowerCase());
    }

    public void removeParameter(String name) {
        this._uri = null;
        this._params.remove(name);
        this._modified = true;
    }

    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new NullPointerException("Null value or name");
        }
        this._uri = null;
        this._params.put(name, value);
        this._modified = true;
    }

    public synchronized Iterator<String> getParameterNames() {
        return this._params.keySet().iterator();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this._params = new HashMap();
            this._uri = in.readUTF();
            this.parse();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean hasBeenModified() {
        return this._modified;
    }
}

