/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.sip.TelURL;
import org.cipango.sip.Modifiable;
import org.cipango.util.StringUtil;

public class TelURLImpl
implements TelURL,
Serializable,
Modifiable {
    private static final long serialVersionUID = 1L;
    private String _uri;
    private String _scheme;
    private String _number;
    private HashMap<String, String> _params;
    private transient boolean _modified;
    public static final String PHONE_CONTEXT = "phone-context";
    private static final BitSet GLOBAL_PHONE_DIGITS = StringUtil.toBitSet((String)"0123456789-.()");
    private static final BitSet LOCAL_PHONE_DIGITS = StringUtil.toBitSet((String)"0123456789abcdefABCDEF-.()*#");

    public TelURLImpl(String uri) throws ParseException {
        this._uri = uri;
        this.parse();
        this._modified = false;
    }

    private void parse() throws ParseException {
        int indexScheme = this._uri.indexOf(58);
        if (indexScheme < 0) {
            throw new ParseException("Missing TelURL scheme in [" + this._uri + "]", indexScheme);
        }
        this._scheme = this._uri.substring(0, indexScheme);
        if (!"tel".equals(this._scheme) && !"fax".equals(this._scheme)) {
            throw new ParseException("Invalid TelURL scheme [" + this._scheme + "] in [" + this._uri + "]", indexScheme);
        }
        int indexParam = this._uri.indexOf(59, indexScheme);
        if (indexParam < 0) {
            this._number = this._uri.substring(indexScheme + 1);
        } else {
            this._number = this._uri.substring(indexScheme + 1, indexParam);
            String sParams = this._uri.substring(indexParam + 1);
            this.parseParams(sParams);
        }
        if (this.isGlobal() && !StringUtil.contains((String)this.getPhoneNumber(), (BitSet)GLOBAL_PHONE_DIGITS)) {
            throw new ParseException("Invalid global phone number [" + this._number + "] in URI [" + this._uri + "]", indexScheme + 1);
        }
        if (!this.isGlobal() && !StringUtil.contains((String)this.getPhoneNumber(), (BitSet)LOCAL_PHONE_DIGITS)) {
            throw new ParseException("Invalid local phone number [" + this._number + "] in URI [" + this._uri + "]", indexScheme + 1);
        }
    }

    private void parseParams(String sParams) throws ParseException {
        this._params = new HashMap();
        StringTokenizer st = new StringTokenizer(sParams, ";");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String param = st.nextToken();
            int index = param.indexOf(61);
            if (index < 0) {
                name = param.trim();
                value = "";
            } else {
                name = param.substring(0, index).trim();
                value = param.substring(index + 1).trim();
            }
            this._params.put(StringUtil.unescape((String)name.toLowerCase()), StringUtil.unescape((String)value));
        }
    }

    public boolean isSipURI() {
        return false;
    }

    public boolean isGlobal() {
        return this._number.startsWith("+");
    }

    public String getPhoneNumber() {
        if (this._number == null) {
            return null;
        }
        if (this.isGlobal()) {
            return this._number.substring(1);
        }
        return this._number;
    }

    public void setPhoneNumber(String number) {
        String n;
        if (!number.startsWith("+")) {
            throw new IllegalArgumentException("Not a global number: " + number);
        }
        String string = n = number.startsWith("+") ? number.substring(1) : number;
        if (!StringUtil.contains((String)n, (BitSet)GLOBAL_PHONE_DIGITS)) {
            throw new IllegalArgumentException("Invalid phone number [" + number + "]");
        }
        this._number = number;
        this._modified = true;
    }

    public void setPhoneNumber(String number, String phoneContext) {
        if (number.startsWith("+")) {
            throw new IllegalArgumentException("Not a local number: " + number);
        }
        if (!StringUtil.contains((String)number, (BitSet)LOCAL_PHONE_DIGITS)) {
            throw new IllegalArgumentException("Invalid phone number [" + number + "]");
        }
        this._number = number;
        this.setParameter(PHONE_CONTEXT, phoneContext);
        this._modified = true;
    }

    public String getPhoneContext() {
        return this.getParameter(PHONE_CONTEXT);
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getParameter(String name) {
        if (this._params == null) {
            return null;
        }
        return this._params.get(name.toLowerCase());
    }

    public void removeParameter(String name) {
        if (this._params != null) {
            this._params.remove(name);
        }
        this._modified = true;
    }

    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new NullPointerException("Null value or name");
        }
        if (this._params == null) {
            this._params = new HashMap();
        }
        this._params.put(name, value);
        this._modified = true;
    }

    public synchronized Iterator<String> getParameterNames() {
        if (this._params == null) {
            return Collections.emptyIterator();
        }
        return this._params.keySet().iterator();
    }

    public TelURL clone() {
        TelURLImpl other;
        try {
            other = (TelURLImpl)super.clone();
        }
        catch (CloneNotSupportedException _) {
            throw new RuntimeException("!cloneable " + this);
        }
        if (this._params != null) {
            other._params = (HashMap)this._params.clone();
        }
        return other;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._scheme);
        sb.append(':');
        sb.append(this._number);
        Iterator<String> it = this.getParameterNames();
        while (it.hasNext()) {
            String name = it.next();
            String value = this.getParameter(name);
            sb.append(';');
            sb.append(StringUtil.encode((String)name, (BitSet)StringUtil.PARAM_BS));
            if (value == null || value.length() <= 0) continue;
            sb.append('=');
            sb.append(StringUtil.encode((String)value, (BitSet)StringUtil.PARAM_BS));
        }
        return sb.toString();
    }

    protected String removeVisualChar(String number) {
        return number.replaceAll("[-\\.\\(\\)]", "");
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TelURL)) {
            return false;
        }
        TelURL other = (TelURL)o;
        if (!this._scheme.equals(other.getScheme())) {
            return false;
        }
        if (!this.removeVisualChar(this.getPhoneNumber()).equals(this.removeVisualChar(other.getPhoneNumber()))) {
            return false;
        }
        if (this.isGlobal() != other.isGlobal()) {
            return false;
        }
        if (this._params != null) {
            for (Map.Entry<String, String> entry : this._params.entrySet()) {
                String otherValue = other.getParameter(entry.getKey());
                if (otherValue == null || entry.getValue().equalsIgnoreCase(otherValue)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasBeenModified() {
        return this._modified;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this._uri = in.readUTF();
            this.parse();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }
}

