/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.nio.ByteBuffer;
import org.cipango.util.StringUtil;
import org.eclipse.jetty.util.StringMap;

public enum SipVersion {
    SIP_2_0("SIP/2.0");

    private String _string;
    private byte[] _bytes;
    private ByteBuffer _buffer;
    public static final StringMap<SipVersion> CACHE;

    private SipVersion(String s) {
        this._string = s;
        this._bytes = StringUtil.getBytes((String)s, (String)"UTF-8");
        this._buffer = ByteBuffer.wrap(this._bytes);
    }

    public ByteBuffer toBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public String asString() {
        return this._string;
    }

    public String toString() {
        return this._string;
    }

    public static SipVersion lookAheadGet(byte[] bytes, int position, int limit) {
        int length = limit - position;
        if (length < 8) {
            return null;
        }
        if (bytes[position] == 83 && bytes[position + 1] == 73 && bytes[position + 2] == 80 && bytes[position + 3] == 47 && bytes[position + 4] == 50 && bytes[position + 5] == 46 && bytes[position + 6] == 48 && Character.isWhitespace((char)bytes[position + 7])) {
            return SIP_2_0;
        }
        return null;
    }

    public static SipVersion lookAheadGet(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            return SipVersion.lookAheadGet(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.arrayOffset() + buffer.limit());
        }
        return null;
    }

    static {
        CACHE = new StringMap(true);
        for (SipVersion version : SipVersion.values()) {
            CACHE.put(version.toString(), (Object)version);
        }
    }
}

