/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.sip.SipURI;
import org.cipango.sip.Modifiable;
import org.cipango.sip.SipScheme;
import org.cipango.util.StringUtil;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.UrlEncoded;

public class SipURIImpl
implements SipURI,
Serializable,
Modifiable {
    private static final long serialVersionUID = 1L;
    public static final String SIP_SCHEME = "sip:";
    public static final String SIPS_SCHEME = "sips:";
    private static final StringMap<Param> CACHE = new StringMap(true);
    private boolean _secure = false;
    private String _user;
    private String _password;
    private String _host;
    private int _port = -1;
    private EnumMap<Param, String> _params;
    private Map<String, String> _otherParameters;
    private Map<String, String> _headers;
    private transient boolean _modified;

    public SipURIImpl(String user, String host, int port) {
        this._user = user;
        this._host = host;
        this._port = port;
        this._modified = false;
    }

    public SipURIImpl(String host, int port) {
        this._host = host;
        this._port = port;
        this._modified = false;
    }

    public SipURIImpl(String uri) throws ParseException {
        this.parse(uri);
        this._modified = false;
    }

    public SipURIImpl() {
    }

    public boolean isSipURI() {
        return true;
    }

    public String getScheme() {
        return this._secure ? SipScheme.SIPS.toString() : SipScheme.SIP.toString();
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void setSecure(boolean b) {
        this._secure = b;
    }

    public String getUser() {
        return this._user;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        if (port < 0) {
            port = -1;
        }
        this._port = port;
    }

    public String getUserPassword() {
        return this._password;
    }

    public void setUserPassword(String password) {
        this._password = password;
    }

    public void parse(String uri) throws ParseException {
        int i = 0;
        int e = uri.length();
        if (uri.startsWith(SIP_SCHEME)) {
            i = 4;
        } else if (uri.startsWith(SIPS_SCHEME)) {
            this._secure = true;
            i = 5;
        } else {
            throw new ParseException("invalid scheme", 0);
        }
        int port = -1;
        int m = i;
        boolean encoded = false;
        String key = null;
        String value = null;
        boolean ipv6Host = false;
        State state = uri.indexOf(64) != -1 ? State.USER : State.HOST;
        while (true) {
            block63: {
                int c = i < e ? (int)uri.charAt(i) : -1;
                block0 : switch (state) {
                    case USER: {
                        switch (c) {
                            case 58: {
                                if (i - m > 0) {
                                    this._user = encoded ? UrlEncoded.decodeString((String)uri, (int)m, (int)(i - m), null) : uri.substring(m, i);
                                }
                                m = i + 1;
                                encoded = false;
                                state = State.PASSWORD;
                                break block0;
                            }
                            case 64: {
                                if (i - m > 0) {
                                    this._user = encoded ? UrlEncoded.decodeString((String)uri, (int)m, (int)(i - m), null) : uri.substring(m, i);
                                }
                                m = i + 1;
                                encoded = false;
                                state = State.HOST;
                                break block0;
                            }
                            case 37: {
                                encoded = true;
                                break block0;
                            }
                            case -1: {
                                throw new ParseException("missing host", i);
                            }
                        }
                        break;
                    }
                    case PASSWORD: {
                        if (c == 64) {
                            if (i - m > 0) {
                                this._password = encoded ? UrlEncoded.decodeString((String)uri, (int)m, (int)(i - m), null) : uri.substring(m, i);
                            }
                            m = i + 1;
                            encoded = false;
                            state = State.HOST;
                            break;
                        }
                        if (c == 37) {
                            encoded = true;
                            break;
                        }
                        if (c != -1) break;
                        throw new ParseException("missing host", i);
                    }
                    case HOST: {
                        if (c == 58 && !ipv6Host) {
                            if (i - m <= 0) {
                                throw new ParseException("missing host", i);
                            }
                            this._host = encoded ? UrlEncoded.decodeString((String)uri, (int)m, (int)(i - m), null) : uri.substring(m, i);
                            m = i + 1;
                            encoded = false;
                            state = State.PORT;
                            break;
                        }
                        if (c == 59) {
                            if (i - m <= 0) {
                                throw new ParseException("missing host", i);
                            }
                            this._host = encoded ? UrlEncoded.decodeString((String)uri, (int)m, (int)(i - m), null) : uri.substring(m, i);
                            m = i;
                            encoded = false;
                            state = State.PARAMETERS;
                            break;
                        }
                        if (c == 63) {
                            if (i - m <= 0) {
                                throw new ParseException("missing host", i);
                            }
                            this._host = encoded ? UrlEncoded.decodeString((String)uri, (int)m, (int)(i - m), null) : uri.substring(m, i);
                            m = i;
                            encoded = false;
                            state = State.HEADERS;
                            break;
                        }
                        if (c == -1) {
                            if (i - m <= 0) {
                                throw new ParseException("missing host", i);
                            }
                            this._host = encoded ? UrlEncoded.decodeString((String)uri, (int)m, (int)(i - m), null) : uri.substring(m, i);
                            return;
                        }
                        if (c == 91) {
                            ipv6Host = true;
                            break;
                        }
                        if (c != 93) break;
                        if (!ipv6Host) {
                            throw new ParseException("invalid host. Got ']' without '['", i);
                        }
                        ipv6Host = false;
                        break;
                    }
                    case PORT: {
                        if (Character.isDigit(c)) {
                            if (port == -1) {
                                port = 0;
                            }
                            if ((port = port * 10 + (c - 48)) <= 65536) break;
                            throw new ParseException("invalid port. Got " + port, i);
                        }
                        if (port != -1) {
                            this._port = port;
                        }
                        if (c == 59) {
                            m = i;
                            state = State.PARAMETERS;
                            break;
                        }
                        if (c == 63) {
                            m = i;
                            state = State.HEADERS;
                            break;
                        }
                        if (c != -1) break;
                        return;
                    }
                    case PARAMETERS: {
                        switch (c) {
                            case 63: {
                                state = State.HEADERS;
                            }
                            case 59: {
                                value = i - m - 1 == 0 ? "" : (encoded ? UrlEncoded.decodeString((String)uri, (int)(m + 1), (int)(i - m - 1), null) : uri.substring(m + 1, i));
                                encoded = false;
                                m = i;
                                if (key != null) {
                                    this.setParameter(key, value);
                                } else if (value != null && value.length() > 0) {
                                    this.setParameter(value, "");
                                }
                                value = null;
                                key = null;
                                break;
                            }
                            case 61: {
                                if (key != null) break;
                                key = encoded ? UrlEncoded.decodeString((String)uri, (int)(m + 1), (int)(i - m - 1), null) : uri.substring(m + 1, i);
                                encoded = false;
                                m = i;
                                break;
                            }
                            case 37: {
                                encoded = true;
                                break;
                            }
                            case -1: {
                                if (key != null) {
                                    value = i - m - 1 == 0 ? "" : (encoded ? UrlEncoded.decodeString((String)uri, (int)(m + 1), (int)(i - m - 1), null) : uri.substring(m + 1));
                                    this.setParameter(key, value);
                                } else if (m < i) {
                                    String string = key = encoded ? UrlEncoded.decodeString((String)uri, (int)(m + 1), (int)(i - m - 1), null) : uri.substring(m + 1);
                                    if (key != null && key.length() > 0) {
                                        this.setParameter(key, "");
                                    }
                                }
                                return;
                            }
                        }
                        break;
                    }
                    case HEADERS: {
                        switch (c) {
                            case 59: {
                                state = State.PARAMETERS;
                            }
                            case 38: {
                                value = i - m - 1 == 0 ? "" : (encoded ? UrlEncoded.decodeString((String)uri, (int)(m + 1), (int)(i - m - 1), null) : uri.substring(m + 1, i));
                                encoded = false;
                                m = i;
                                if (key != null && value != null) {
                                    this.setHeader(key, value);
                                }
                                value = null;
                                key = null;
                                break block0;
                            }
                            case 61: {
                                if (key == null) {
                                    key = encoded ? UrlEncoded.decodeString((String)uri, (int)(m + 1), (int)(i - m - 1), null) : uri.substring(m + 1, i);
                                    encoded = false;
                                    m = i;
                                    break block0;
                                }
                                break block63;
                            }
                            case 37: {
                                encoded = true;
                                break block0;
                            }
                            case -1: {
                                if (key != null) {
                                    value = i - m - 1 == 0 ? "" : (encoded ? UrlEncoded.decodeString((String)uri, (int)(m + 1), (int)(i - m - 1), null) : uri.substring(m + 1));
                                    this.setHeader(key, value);
                                }
                                return;
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private String getParameter(Param name) {
        if (this._params == null) {
            return null;
        }
        return this._params.get((Object)name);
    }

    private synchronized void setParameter(Param name, String value) {
        if (this._params == null) {
            this._params = new EnumMap(Param.class);
        }
        this._params.put(name, value);
    }

    private void removeParameter(Param name) {
        if (this._params != null) {
            this._params.remove((Object)name);
        }
    }

    public String getParameter(String name) {
        Param param = (Param)((Object)CACHE.get(name));
        if (param != null) {
            return this.getParameter(param);
        }
        return this._otherParameters == null ? null : this._otherParameters.get(name);
    }

    public Iterator<String> getParameterNames() {
        ArrayList<String> list = new ArrayList<String>();
        if (this._params != null) {
            for (Param param : this._params.keySet()) {
                list.add(param.toString());
            }
        }
        if (this._otherParameters != null) {
            list.addAll(this._otherParameters.keySet());
        }
        return list.iterator();
    }

    public void removeParameter(String name) {
        Param param = (Param)((Object)CACHE.get(name));
        if (param != null) {
            this.removeParameter(param);
        } else if (this._otherParameters != null) {
            this._otherParameters.remove(name);
        }
        this._modified = true;
    }

    public void setParameter(String name, String value) {
        if (name == null || value == null) {
            throw new NullPointerException("Null value or name");
        }
        Param param = (Param)((Object)CACHE.get(name));
        if (param != null) {
            this.setParameter(param, value);
        } else {
            if (this._otherParameters == null) {
                this._otherParameters = new HashMap<String, String>();
            }
            this._otherParameters.put(name, value);
        }
        this._modified = true;
    }

    public boolean getLrParam() {
        return "".equals(this.getParameter(Param.LR));
    }

    public String getMAddrParam() {
        return this.getParameter(Param.MADDR);
    }

    public String getMethodParam() {
        return this.getParameter(Param.METHOD);
    }

    public int getTTLParam() {
        String s = this.getParameter(Param.TTL);
        return s != null ? Integer.parseInt(s) : -1;
    }

    public String getTransportParam() {
        return this.getParameter(Param.TRANSPORT);
    }

    public void setHost(String host) {
        this._host = host.contains(":") && !host.contains("[") ? "[" + host + "]" : host;
        this._modified = true;
    }

    public void setUser(String user) {
        this._user = user;
        this._modified = true;
    }

    public void setLrParam(boolean b) {
        if (b) {
            this.setParameter(Param.LR, "");
        } else {
            this.removeParameter(Param.LR);
        }
    }

    public String getUserParam() {
        return this.getParameter(Param.USER);
    }

    public void removeHeader(String name) {
        if (this._headers != null) {
            this._headers.remove(name);
        }
        this._modified = true;
    }

    public void setHeader(String name, String value) {
        if (this._headers == null) {
            this._headers = new HashMap<String, String>();
        }
        this._headers.put(name, value);
        this._modified = true;
    }

    public void setMAddrParam(String maddr) {
        this.setParameter(Param.MADDR, maddr);
    }

    public void setMethodParam(String method) {
        this.setParameter(Param.METHOD, method);
    }

    public void setTTLParam(int ttl) {
        this.setParameter(Param.TTL, Integer.toString(ttl));
    }

    public void setTransportParam(String transport) {
        this.setParameter(Param.TRANSPORT, transport);
    }

    public void setUserParam(String user) {
        this.setParameter(Param.USER, user);
    }

    public String getHeader(String name) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        return this._headers != null ? this._headers.get(name) : null;
    }

    public Iterator<String> getHeaderNames() {
        if (this._headers == null) {
            return Collections.emptyIterator();
        }
        return new ArrayList<String>(this._headers.keySet()).iterator();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(this._secure ? SIPS_SCHEME : SIP_SCHEME);
        if (this._user != null) {
            buffer.append(this._user);
            if (this._password != null) {
                buffer.append(':');
                buffer.append(this._password);
            }
            buffer.append('@');
        }
        buffer.append(this._host);
        if (this._port > 0) {
            buffer.append(':');
            buffer.append(this._port);
        }
        if (this._params != null && this._params.size() > 0) {
            for (Param p : Param.values()) {
                if (!this._params.containsKey((Object)p)) continue;
                String value = this._params.get((Object)p);
                buffer.append(';');
                buffer.append(p.asString());
                if (value == null || value.equals("")) continue;
                buffer.append('=');
                buffer.append(StringUtil.encode((String)value, (BitSet)StringUtil.PARAM_BS));
            }
        }
        if (this._otherParameters != null) {
            for (String name : this._otherParameters.keySet()) {
                String value = this._otherParameters.get(name);
                buffer.append(';');
                buffer.append(StringUtil.encode((String)name, (BitSet)StringUtil.PARAM_BS));
                if (value == null || value.equals("")) continue;
                buffer.append('=');
                buffer.append(StringUtil.encode((String)value, (BitSet)StringUtil.PARAM_BS));
            }
        }
        Iterator<String> it2 = this.getHeaderNames();
        boolean first = true;
        while (it2.hasNext()) {
            String name = it2.next();
            String value = this.getHeader(name);
            if (first) {
                first = false;
                buffer.append('?');
            } else {
                buffer.append('&');
            }
            buffer.append(StringUtil.encode((String)name, (BitSet)StringUtil.HEADER_BS));
            buffer.append('=');
            buffer.append(StringUtil.encode((String)value, (BitSet)StringUtil.HEADER_BS));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        Iterator headers;
        if (o == null || !(o instanceof SipURI)) {
            return false;
        }
        SipURI uri = (SipURI)o;
        if (this._secure != uri.isSecure()) {
            return false;
        }
        if (!StringUtil.equals((String)this._user, (String)uri.getUser())) {
            return false;
        }
        if (!StringUtil.equals((String)this._password, (String)uri.getUserPassword())) {
            return false;
        }
        if (!this._host.equalsIgnoreCase(uri.getHost())) {
            return false;
        }
        if (this._port != uri.getPort()) {
            return false;
        }
        for (Param param : Param.values()) {
            if (!(param == Param.LR ? this.getParameter(Param.LR) != null && uri.getParameter(Param.LR.asString()) != null && this.getLrParam() != uri.getLrParam() : !StringUtil.equalsIgnoreCase((String)this.getParameter(param), (String)uri.getParameter(param.asString())))) continue;
            return false;
        }
        if (this._otherParameters != null) {
            Iterator parameters = uri.getParameterNames();
            while (parameters.hasNext()) {
                String name = (String)parameters.next();
                if (!this._otherParameters.containsKey(name) || StringUtil.equalsIgnoreCase((String)this._otherParameters.get(name), (String)uri.getParameter(name))) continue;
                return false;
            }
        }
        if ((headers = uri.getHeaderNames()).hasNext()) {
            if (this._headers == null) {
                return false;
            }
            int i = 0;
            while (headers.hasNext()) {
                String name = (String)headers.next();
                if (!uri.getHeader(name).equals(this._headers.get(name))) {
                    return false;
                }
                ++i;
            }
            if (i != this._headers.size()) {
                return false;
            }
        } else if (this._headers != null && this._headers.size() > 0) {
            return false;
        }
        return true;
    }

    public SipURIImpl clone() {
        try {
            SipURIImpl clone = (SipURIImpl)super.clone();
            if (this._params != null) {
                clone._params = this._params.clone();
            }
            if (this._otherParameters != null) {
                clone._otherParameters = new HashMap<String, String>(this._otherParameters);
            }
            if (this._headers != null) {
                clone._headers = new HashMap<String, String>(this._headers);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this._port = -1;
            this.parse(in.readUTF());
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean hasBeenModified() {
        return this._modified;
    }

    static {
        for (Param param : Param.values()) {
            CACHE.put(param.toString(), (Object)param);
        }
    }

    static enum Host {
        IPV4,
        NAME,
        IPV6;

    }

    static enum State {
        USER,
        PASSWORD,
        HOST,
        PORT,
        PARAMETERS,
        HEADERS;

    }

    public static enum Param {
        TRANSPORT,
        TTL,
        MADDR,
        METHOD,
        USER,
        LR;

        private String _string = this.name().toLowerCase();

        public String toString() {
            return this._string;
        }

        public String asString() {
            return this._string;
        }
    }
}

