/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

public enum SipStatus {
    TRYING(100, "Trying"),
    RINGING(180, "Ringing"),
    CALL_IS_BEING_FORWARDED(181, "Call Is Being Forwarded"),
    QUEUED(182, "Queued"),
    SESSION_PROGRESS(183, "Session Progress"),
    OK(200, "OK"),
    ACCEPTED(202, "Accepted"),
    MULTIPLE_CHOICES(300, "Multiple Choices"),
    MOVED_PERMANENTLY(301, "Moved Permanently"),
    MOVED_TEMPORARILY(302, "Moved Temporarily"),
    USE_PROXY(305, "Use Proxy"),
    ALTERNATE_SERVICE(380, "Alternative Service"),
    BAD_REQUEST(400, "Bad Request"),
    UNAUTHORIZED(401, "Unauthorized"),
    PAYMENT_REQUIRED(402, "Payment Required"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    NOT_ACCEPTABLE(406, "Not Acceptable"),
    PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
    REQUEST_TIMEOUT(408, "Request Timeout"),
    GONE(410, "Gone"),
    CONDITIONAL_REQUEST_FAILED(412, "Conditional Request Failed"),
    REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    REQUEST_URI_TOO_LONG(414, "Request-URI Too Long"),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
    UNSUPPORTED_URI_SCHEME(416, "Unsupported URI Scheme"),
    UNKNOWN_RESOURCE_PRIORITY(417, "Unknown Resource-Priority"),
    BAD_EXTENSION(420, "Bad Extension"),
    EXTENSION_REQUIRED(421, "Extension Required"),
    SESSION_INTERVAL_TOO_SMALL(422, "Session Interval Too Small"),
    INTERVAL_TOO_BRIEF(423, "Interval Too Brief"),
    USE_IDENTITY_HEADER(428, "Use Identity Header"),
    PROVIDE_REFERRER_IDENTITY(429, "Provide Referrer Identity"),
    BAD_IDENTITY_INFO(436, "Bad Identity-Info"),
    UNSUPPORTED_CERTIFICATE(437, "Unsupported Certificate"),
    INVALID_IDENTITY_HEADER(438, "Invalid Identity Header"),
    TEMPORARILY_UNAVAILABLE(480, "Temporarily Unavailable"),
    CALL_TRANSACTION_DOES_NOT_EXIST(481, "Call/Transaction Does Not Exist"),
    LOOP_DETECTED(482, "Loop Detected"),
    TOO_MANY_HOPS(483, "Too Many Hops"),
    ADDRESS_IMCOMPLETE(484, "Address Incomplete"),
    AMBIGUOUS(485, "Ambiguous"),
    BUSY_HERE(486, "Busy Here"),
    REQUEST_TERMINATED(487, "Request Terminated"),
    NOT_ACCEPTABLE_HERE(488, "Not Acceptable Here"),
    BAD_EVENT(489, "Bad Event"),
    REQUEST_PENDING(491, "Request Pending"),
    UNDECIPHERABLE(493, "Undecipherable"),
    SECURITY_AGREEMENT_REQUIRED(494, "Security Agreement Required"),
    SERVER_INTERNAL_ERROR(500, "Server Internal Error"),
    NOT_IMPLEMENTED(501, "Not Implemented"),
    BAD_GATEWAY(502, "Bad Gateway"),
    SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    SERVER_TIMEOUT(504, "Server Time-out"),
    VERSION_NOT_SUPPORTED(505, "Version Not Supported"),
    MESSAGE_TOO_LARGE(513, "Message Too Large"),
    PRECONDITION_FAILURE(580, "Precondition Failure"),
    BUSY_EVERYWHERE(600, "Busy Everywhere"),
    DECLINE(603, "Decline"),
    DOES_NOT_EXIST_ANYWHERE(604, "Does Not Exist Anywhere"),
    NOT_ACCEPTABLE_ANYWHERE(606, "Not Acceptable");

    public static final int MAX_CODE = 606;
    private static final SipStatus[] __map;
    private int _code;
    private String _reason;

    public static SipStatus get(int code) {
        if (code <= 606) {
            return __map[code];
        }
        return null;
    }

    private SipStatus(int code, String reason) {
        this._code = code;
        this._reason = reason;
    }

    public int getCode() {
        return this._code;
    }

    public String getReason() {
        return this._reason;
    }

    public static boolean isSuccess(int code) {
        return 200 <= code && code < 300;
    }

    static {
        __map = new SipStatus[607];
        SipStatus[] arr$ = SipStatus.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            SipStatus status;
            SipStatus.__map[status._code] = status = arr$[i$];
        }
    }
}

