/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.BitSet;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipMethod;
import org.cipango.sip.SipVersion;
import org.cipango.util.StringScanner;
import org.cipango.util.StringUtil;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SipParser {
    private SipMessageHandler _handler;
    private SipHeader _header;
    private String _headerString;
    private String _valueString;
    private State _state = State.START;
    private SipMethod _method;
    private String _methodString;
    private String _uri;
    private SipVersion _version;
    private long _status;
    private byte _eol;
    private long _contentLength;
    private ByteBuffer _content;
    private final StringBuilder _string = new StringBuilder();
    private final Utf8StringBuilder _utf8 = new Utf8StringBuilder();
    private int _length;
    private static final Logger LOG = Log.getLogger(SipParser.class);
    private static final BitSet COMMA_QUOTE_BS = StringUtil.toBitSet((String)",\"");

    public SipParser(SipMessageHandler eventHandler) {
        this._handler = eventHandler;
    }

    public State getState() {
        return this._state;
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    private void quickStart(ByteBuffer buffer) {
        while (this._state == State.START && buffer.hasRemaining()) {
            this._version = SipVersion.lookAheadGet(buffer);
            if (this._version != null) {
                buffer.position(buffer.position() + this._version.asString().length() + 1);
                this._state = State.SPACE1;
                return;
            }
            this._method = SipMethod.lookAheadGet(buffer);
            if (this._method != null) {
                this._methodString = this._method.asString();
                buffer.position(buffer.position() + this._methodString.length() + 1);
                this._state = State.SPACE1;
                return;
            }
            byte ch = buffer.get();
            if (this._eol == 13 && ch == 10) {
                this._eol = (byte)10;
                continue;
            }
            this._eol = 0;
            if (ch <= 32 && ch >= 0) continue;
            this._string.setLength(0);
            this._string.append((char)ch);
            this._state = State.METHOD_OR_VERSION;
            return;
        }
    }

    private boolean parseLine(ByteBuffer buffer) throws ParseException {
        boolean returnFromParse = false;
        while (this._state.ordinal() < State.HEADER.ordinal() && buffer.hasRemaining() && !returnFromParse) {
            byte ch = buffer.get();
            if (this._eol == 13 && ch == 10) {
                this._eol = (byte)10;
                continue;
            }
            this._eol = 0;
            switch (this._state) {
                case METHOD_OR_VERSION: {
                    if (ch == 32) {
                        String methodOrVersion = this.takeString();
                        SipVersion version = (SipVersion)((Object)SipVersion.CACHE.get(methodOrVersion));
                        if (version == null) {
                            SipMethod method = (SipMethod)((Object)SipMethod.CACHE.get(methodOrVersion));
                            this._methodString = method != null ? method.toString() : methodOrVersion;
                        } else {
                            this._version = version;
                        }
                        this._state = State.SPACE1;
                        break;
                    }
                    if (ch < 32 && ch >= 0) {
                        this.badMessage(buffer, "No URI");
                        return true;
                    }
                    this._string.append((char)ch);
                    break;
                }
                case SPACE1: {
                    if (ch > 32 || ch < 0) {
                        if (Character.isDigit(ch)) {
                            this._state = State.STATUS;
                            this._status = ch - 48;
                            if (this._version != null) break;
                            this.badMessage(buffer, "Unknown Version: " + this._methodString);
                            return true;
                        }
                        this._state = State.URI;
                        this._utf8.reset();
                        this._utf8.append(ch);
                        if (this._version == null) break;
                        this.badMessage(buffer, "Invalid status");
                        return true;
                    }
                    if (ch >= 32) break;
                    this.badMessage(buffer, "No URI");
                    return true;
                }
                case URI: {
                    if (ch == 32) {
                        this._uri = this._utf8.toString();
                        this._utf8.reset();
                        this._state = State.SPACE2;
                        break;
                    }
                    this._utf8.append(ch);
                    break;
                }
                case STATUS: {
                    if (ch == 32) {
                        if (this._status < 100L || this._status >= 700L) {
                            throw new ParseException("Invalid status code: " + this._status, buffer.position());
                        }
                        this._state = State.SPACE2;
                        break;
                    }
                    if (Character.isDigit(ch)) {
                        this._status = this._status * 10L + (long)ch - 48L;
                        break;
                    }
                    throw new ParseException("Invalid status code: " + this._status + (char)ch, buffer.position());
                }
                case SPACE2: {
                    if (ch > 32 || ch < 0) {
                        this._string.setLength(0);
                        this._string.append((char)ch);
                        if (this._status == 0L) {
                            this._state = State.REQUEST_VERSION;
                            if (buffer.position() <= 0 || !buffer.hasArray()) break;
                            this._version = SipVersion.lookAheadGet(buffer.array(), buffer.arrayOffset() + buffer.position() - 1, buffer.arrayOffset() + buffer.limit());
                            if (this._version == null) break;
                            this._string.setLength(0);
                            buffer.position(buffer.position() + this._version.asString().length() - 1);
                            this._eol = buffer.get();
                            this._state = State.HEADER;
                            returnFromParse |= this._handler.startRequest(this._methodString, this._uri, this._version);
                            break;
                        }
                        this._state = State.REASON_PHRASE;
                        break;
                    }
                    if (ch != 13 && ch != 10) break;
                    this._eol = ch;
                    this._state = State.HEADER;
                    returnFromParse |= this._handler.startResponse(this._version, (int)this._status, "");
                    break;
                }
                case REQUEST_VERSION: {
                    if (ch == 13 || ch == 10) {
                        String version = this.takeString();
                        this._version = (SipVersion)((Object)SipVersion.CACHE.get(version));
                        if (this._version == null) {
                            this.badMessage(buffer, "Unknown Version");
                            return true;
                        }
                        this._eol = ch;
                        this._state = State.HEADER;
                        returnFromParse |= this._handler.startRequest(this._methodString, this._uri, this._version);
                        break;
                    }
                    this._string.append((char)ch);
                    break;
                }
                case REASON_PHRASE: {
                    if (ch == 13 || ch == 10) {
                        String reason = this.takeString();
                        this._eol = ch;
                        this._state = State.HEADER;
                        returnFromParse |= this._handler.startResponse(this._version, (int)this._status, reason);
                        break;
                    }
                    this._string.append((char)ch);
                }
            }
        }
        return returnFromParse;
    }

    private boolean parseHeaders(ByteBuffer buffer) {
        boolean returnFromParse = false;
        while (this._state.ordinal() < State.END.ordinal() && buffer.hasRemaining() && !returnFromParse) {
            byte ch = buffer.get();
            if (this._eol == 13 && ch == 10) {
                this._eol = (byte)10;
                continue;
            }
            this._eol = 0;
            block2 : switch (this._state) {
                case HEADER: {
                    switch (ch) {
                        case 9: 
                        case 32: 
                        case 58: {
                            this._length = -1;
                            this._string.setLength(0);
                            this._state = State.HEADER_VALUE;
                            break block2;
                        }
                    }
                    if (this._headerString != null || this._valueString != null) {
                        if (this._header == SipHeader.CONTENT_LENGTH) {
                            try {
                                this._contentLength = Long.parseLong(this._valueString.trim());
                            }
                            catch (NumberFormatException e) {
                                this.badMessage(buffer, "Invalid Content-Length");
                                return true;
                            }
                        }
                        if (this._header != null && this._header.isList()) {
                            StringScanner scanner = new StringScanner(this._valueString);
                            while (!scanner.eof()) {
                                scanner.skipToOneOf(COMMA_QUOTE_BS);
                                if (scanner.eof()) {
                                    returnFromParse |= this._handler.parsedHeader(this._header, this._headerString, scanner.sliceFromMark());
                                    continue;
                                }
                                if (scanner.peekChar() == ',') {
                                    scanner.skipBackWhitespace();
                                    returnFromParse |= this._handler.parsedHeader(this._header, this._headerString, scanner.sliceFromMark());
                                    scanner.skipWhitespace();
                                    scanner.skipChar();
                                    scanner.skipWhitespace();
                                    scanner.mark();
                                    continue;
                                }
                                try {
                                    scanner.readQuoted();
                                    if (!scanner.eof()) continue;
                                    returnFromParse |= this._handler.parsedHeader(this._header, this._headerString, scanner.sliceFromMark());
                                }
                                catch (ParseException e) {
                                    this.badMessage(buffer, "Invalid quoted message");
                                    return true;
                                }
                            }
                        } else {
                            returnFromParse |= this._handler.parsedHeader(this._header, this._headerString, this._valueString);
                        }
                    }
                    this._valueString = null;
                    this._headerString = null;
                    this._header = null;
                    if (ch == 13 || ch == 10) {
                        this.consumeCRLF(ch, buffer);
                        if (this._contentLength == 0L) {
                            returnFromParse |= this._handler.headerComplete();
                            this._state = State.END;
                            returnFromParse |= this._handler.messageComplete(null);
                            break;
                        }
                        returnFromParse |= this._handler.headerComplete();
                        this._state = State.CONTENT;
                        break;
                    }
                    if (buffer.remaining() > 6 && buffer.hasArray()) {
                        this._header = SipHeader.lookAheadGet(buffer.array(), buffer.arrayOffset() + buffer.position() - 1, buffer.arrayOffset() + buffer.limit());
                        if (this._header != null) {
                            this._headerString = this._header.asString();
                            buffer.position(buffer.position() + this._headerString.length());
                            this._state = buffer.get(buffer.position() - 1) == 58 ? State.HEADER_VALUE : State.HEADER_NAME;
                            break;
                        }
                    }
                    this._state = State.HEADER_NAME;
                    this._string.setLength(0);
                    this._string.append((char)ch);
                    this._length = 1;
                    break;
                }
                case HEADER_NAME: {
                    switch (ch) {
                        case 10: 
                        case 13: {
                            this.consumeCRLF(ch, buffer);
                            this._headerString = this.takeLengthString();
                            this._header = (SipHeader)((Object)SipHeader.CACHE.get(this._headerString));
                            this._state = State.HEADER;
                            break block2;
                        }
                        case 58: {
                            if (this._headerString == null) {
                                this._headerString = this.takeLengthString();
                                this._header = (SipHeader)((Object)SipHeader.CACHE.get(this._headerString));
                            }
                            this._state = State.HEADER_VALUE;
                            break block2;
                        }
                        case 9: 
                        case 32: {
                            this._string.append((char)ch);
                            break block2;
                        }
                    }
                    if (this._header != null) {
                        this._string.setLength(0);
                        this._string.append(this._header.asString());
                        this._string.append(' ');
                        this._length = this._string.length();
                        this._header = null;
                        this._headerString = null;
                    }
                    this._string.append((char)ch);
                    this._length = this._string.length();
                    this._state = State.HEADER_IN_NAME;
                    break;
                }
                case HEADER_IN_NAME: {
                    switch (ch) {
                        case 10: 
                        case 13: {
                            this.consumeCRLF(ch, buffer);
                            this._headerString = this.takeString();
                            this._length = -1;
                            this._header = (SipHeader)((Object)SipHeader.CACHE.get(this._headerString));
                            this._state = State.HEADER;
                            break block2;
                        }
                        case 58: {
                            if (this._headerString == null) {
                                this._headerString = this.takeString();
                                this._header = (SipHeader)((Object)SipHeader.CACHE.get(this._headerString));
                            }
                            this._length = -1;
                            this._state = State.HEADER_VALUE;
                            break block2;
                        }
                        case 9: 
                        case 32: {
                            this._state = State.HEADER_NAME;
                            this._string.append((char)ch);
                            break block2;
                        }
                    }
                    this._string.append((char)ch);
                    ++this._length;
                    break;
                }
                case HEADER_VALUE: {
                    switch (ch) {
                        case 10: 
                        case 13: {
                            this.consumeCRLF(ch, buffer);
                            if (this._length > 0) {
                                this._valueString = this._valueString != null ? this._valueString + " " + this.takeLengthString() : this.takeLengthString();
                            }
                            this._state = State.HEADER;
                            break block2;
                        }
                        case 9: 
                        case 32: {
                            break block2;
                        }
                    }
                    this._string.append((char)ch);
                    this._length = this._string.length();
                    this._state = State.HEADER_IN_VALUE;
                    break;
                }
                case HEADER_IN_VALUE: {
                    switch (ch) {
                        case 10: 
                        case 13: {
                            this.consumeCRLF(ch, buffer);
                            if (this._length > 0) {
                                this._valueString = this._valueString != null ? this._valueString + " " + this.takeString() : this.takeString();
                            }
                            this._length = -1;
                            this._state = State.HEADER;
                            break block2;
                        }
                        case 9: 
                        case 32: {
                            this._string.append((char)ch);
                            this._state = State.HEADER_VALUE;
                            break block2;
                        }
                    }
                    this._string.append((char)ch);
                    ++this._length;
                }
            }
        }
        return returnFromParse;
    }

    public boolean parseNext(ByteBuffer buffer) {
        try {
            switch (this._state) {
                case START: {
                    this._version = null;
                    this._method = null;
                    this._methodString = null;
                    this._uri = null;
                    this._header = null;
                    this._contentLength = -1L;
                    this.quickStart(buffer);
                    break;
                }
                case END: {
                    return false;
                }
            }
            if (this._state.ordinal() < State.HEADER.ordinal() && this.parseLine(buffer)) {
                return true;
            }
            if (this._state.ordinal() < State.END.ordinal() && this.parseHeaders(buffer)) {
                return true;
            }
            if (this._state == State.CONTENT) {
                ByteBuffer content;
                if (this._eol == 13 && buffer.hasRemaining() && buffer.get(buffer.position()) == 10) {
                    buffer.get();
                    this._eol = 0;
                }
                if (!(content = this.getContent(buffer)).isReadOnly() && buffer.hasRemaining()) {
                    int remaining = (int)Math.min((long)buffer.remaining(), this._contentLength - (long)content.position());
                    buffer.get(content.array(), content.position(), remaining);
                    content.position(content.position() + remaining);
                    if (content.position() == content.limit()) {
                        content.flip();
                        content = content.asReadOnlyBuffer();
                    }
                }
                if (content.isReadOnly()) {
                    this._state = State.END;
                    this.releaseContent();
                    if (this._handler.messageComplete(content)) {
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            this._handler.badMessage(400, e.toString());
            return true;
        }
    }

    private void badMessage(ByteBuffer buffer, String reason) {
        BufferUtil.clear((ByteBuffer)buffer);
        this._state = State.END;
        this._handler.badMessage(400, reason);
    }

    private ByteBuffer getContent(ByteBuffer buffer) {
        if (this._content == null) {
            if (this._contentLength == -1L) {
                this._content = buffer.asReadOnlyBuffer();
            } else if ((long)buffer.remaining() >= this._contentLength) {
                this._content = buffer.asReadOnlyBuffer();
                if ((long)this._content.remaining() > this._contentLength) {
                    this._content.limit(this._content.position() + (int)this._contentLength);
                }
                buffer.position(this._content.position() + (int)this._contentLength);
            } else {
                this._content = ByteBuffer.allocate((int)this._contentLength);
            }
        }
        return this._content;
    }

    private void releaseContent() {
        this._content = null;
    }

    private String takeString() {
        String s = this._string.toString();
        this._string.setLength(0);
        return s;
    }

    private String takeLengthString() {
        this._string.setLength(this._length);
        String s = this._string.toString();
        this._string.setLength(0);
        this._length = -1;
        return s;
    }

    private void consumeCRLF(byte ch, ByteBuffer buffer) {
        this._eol = ch;
        if (this._eol == 13 && buffer.hasRemaining() && buffer.get(buffer.position()) == 10) {
            buffer.get();
            this._eol = 0;
        }
    }

    public void reset() {
        this._state = State.START;
        this._method = null;
        this._methodString = null;
        this._uri = null;
        this._status = 0L;
    }

    public String toString() {
        return String.format("%s{s=%s}", new Object[]{this.getClass().getSimpleName(), this._state});
    }

    public static interface SipMessageHandler {
        public boolean startRequest(String var1, String var2, SipVersion var3) throws ParseException;

        public boolean startResponse(SipVersion var1, int var2, String var3) throws ParseException;

        public boolean parsedHeader(SipHeader var1, String var2, String var3);

        public boolean headerComplete();

        public boolean messageComplete(ByteBuffer var1);

        public void badMessage(int var1, String var2);
    }

    public static enum State {
        START,
        METHOD_OR_VERSION,
        SPACE1,
        URI,
        STATUS,
        SPACE2,
        REQUEST_VERSION,
        REASON_PHRASE,
        HEADER,
        HEADER_NAME,
        HEADER_IN_NAME,
        HEADER_VALUE,
        HEADER_IN_VALUE,
        END,
        CONTENT;

    }
}

