/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.StringMap;

public enum SipMethod {
    ACK,
    BYE,
    CANCEL,
    INFO,
    INVITE,
    MESSAGE,
    NOTIFY,
    OPTIONS,
    PRACK,
    PUBLISH,
    REFER,
    REGISTER,
    SUBSCRIBE,
    UPDATE;

    public static final StringMap<SipMethod> CACHE;

    public String asString() {
        return this.toString();
    }

    public static SipMethod lookAheadGet(byte[] bytes, int position, int limit) {
        int length = limit - position;
        if (length < 4) {
            return null;
        }
        switch (bytes[position]) {
            case 65: {
                if (bytes[position + 1] != 67 || bytes[position + 2] != 75 || bytes[position + 3] != 32) break;
                return ACK;
            }
            case 66: {
                if (bytes[position + 1] != 89 || bytes[position + 2] != 69 || bytes[position + 3] != 32) break;
                return BYE;
            }
            case 67: {
                if (length < 7 || bytes[position + 1] != 65 || bytes[position + 2] != 78 || bytes[position + 3] != 67 || bytes[position + 4] != 69 || bytes[position + 5] != 76 || bytes[position + 6] != 32) break;
                return CANCEL;
            }
            case 73: {
                if (bytes[position + 1] == 78 && bytes[position + 2] == 70 && bytes[position + 3] == 79 && length >= 5 && bytes[position + 4] == 32) {
                    return INFO;
                }
                if (bytes[position + 1] != 78 || bytes[position + 2] != 86 || bytes[position + 3] != 73 || length < 7 || bytes[position + 4] != 84 || bytes[position + 5] != 69 || bytes[position + 6] != 32) break;
                return INVITE;
            }
            case 77: {
                if (length < 8 || bytes[position + 1] != 69 || bytes[position + 2] != 83 || bytes[position + 3] != 83 || bytes[position + 4] != 65 || bytes[position + 5] != 71 || bytes[position + 6] != 69 || bytes[position + 7] != 32) break;
                return MESSAGE;
            }
            case 78: {
                if (length < 7 || bytes[position + 1] != 79 || bytes[position + 2] != 84 || bytes[position + 3] != 73 || bytes[position + 4] != 70 || bytes[position + 5] != 89 || bytes[position + 6] != 32) break;
                return NOTIFY;
            }
            case 79: {
                if (length < 8 || bytes[position + 1] != 80 || bytes[position + 2] != 84 || bytes[position + 3] != 73 || bytes[position + 4] != 79 || bytes[position + 5] != 78 || bytes[position + 6] != 83 || bytes[position + 7] != 32) break;
                return OPTIONS;
            }
            case 80: {
                if (length >= 6 && bytes[position + 1] == 82 && bytes[position + 2] == 65 && bytes[position + 3] == 67 && bytes[position + 4] == 75 && bytes[position + 5] == 32) {
                    return PRACK;
                }
                if (length < 8 || bytes[position + 1] != 85 || bytes[position + 2] != 66 || bytes[position + 3] != 76 || bytes[position + 4] != 73 || bytes[position + 5] != 83 || bytes[position + 6] != 72 || bytes[position + 7] != 32) break;
                return PUBLISH;
            }
            case 82: {
                if (bytes[position + 1] == 69 && bytes[position + 2] == 70 && bytes[position + 3] == 69 && length >= 6 && bytes[position + 4] == 82 && bytes[position + 5] == 32) {
                    return REFER;
                }
                if (bytes[position + 1] != 69 || bytes[position + 2] != 71 || bytes[position + 3] != 73 || length < 9 || bytes[position + 4] != 83 || bytes[position + 5] != 84 || bytes[position + 6] != 69 || bytes[position + 7] != 82 || bytes[position + 8] != 32) break;
                return REGISTER;
            }
            case 83: {
                if (length < 10 || bytes[position + 1] != 85 || bytes[position + 2] != 66 || bytes[position + 3] != 83 || bytes[position + 4] != 67 || bytes[position + 5] != 82 || bytes[position + 6] != 73 || bytes[position + 7] != 66 || bytes[position + 8] != 69 || bytes[position + 9] != 32) break;
                return SUBSCRIBE;
            }
            case 85: {
                if (length < 7 || bytes[position + 1] != 80 || bytes[position + 2] != 68 || bytes[position + 3] != 65 || bytes[position + 4] != 84 || bytes[position + 5] != 69 || bytes[position + 6] != 32) break;
                return UPDATE;
            }
        }
        return null;
    }

    public static SipMethod lookAheadGet(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            return SipMethod.lookAheadGet(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.arrayOffset() + buffer.limit());
        }
        return null;
    }

    public static SipMethod get(String method) {
        byte[] b = (method + " ").getBytes();
        return SipMethod.lookAheadGet(b, 0, b.length);
    }

    static {
        CACHE = new StringMap(true);
        for (SipMethod method : SipMethod.values()) {
            CACHE.put(method.toString(), (Object)method);
        }
    }
}

