/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.Set;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.URI;
import org.cipango.sip.SipFields;
import org.cipango.sip.SipGrammar;
import org.cipango.sip.SipHeader;
import org.cipango.sip.SipStatus;
import org.cipango.sip.SipVersion;
import org.cipango.util.StringUtil;

public class SipGenerator {
    private Set<SipHeader> _fixedHeaders = EnumSet.of(SipHeader.VIA, SipHeader.FROM, SipHeader.TO, SipHeader.CALL_ID);
    private static byte[] CONTENT_LENGTH_0 = "Content-Length: 0\r\n".getBytes();
    private static byte[] CONTENT_LENGTH_0_COMPACT = "l: 0\r\n".getBytes();
    private static final PreparedResponse[] __responses = new PreparedResponse[607];

    public void generateRequest(ByteBuffer buffer, String method, URI requestUri, SipFields sipFields, byte[] content, SipServletMessage.HeaderForm headerForm) {
        this.generateRequestLine(buffer, method, requestUri);
        this.generateHeaders(buffer, sipFields, headerForm);
        if (content != null) {
            buffer.put(content);
        }
    }

    public void generateResponse(ByteBuffer buffer, int status, String reason, SipFields sipFields, byte[] content, SipServletMessage.HeaderForm headerForm) {
        this.generateResponseLine(buffer, status, reason);
        this.generateHeaders(buffer, sipFields, headerForm);
        if (content != null) {
            buffer.put(content);
        }
    }

    public void generateRequestLine(ByteBuffer buffer, String method, URI requestUri) {
        buffer.put(StringUtil.getUtf8Bytes((String)method));
        buffer.put((byte)32);
        buffer.put(StringUtil.getUtf8Bytes((String)requestUri.toString()));
        buffer.put((byte)32);
        buffer.put(SipVersion.SIP_2_0.toBuffer());
        buffer.put(SipGrammar.CRLF);
    }

    public void generateResponseLine(ByteBuffer buffer, int status, String reason) {
        PreparedResponse prepared;
        PreparedResponse preparedResponse = prepared = status < __responses.length ? __responses[status] : null;
        if (prepared != null) {
            if (reason == null) {
                buffer.put(prepared._responseLine);
            } else {
                buffer.put(prepared._schemeCode);
                buffer.put(StringUtil.getBytes((String)reason, (String)"UTF-8"));
                buffer.put(SipGrammar.CRLF);
            }
        } else {
            buffer.put(SipVersion.SIP_2_0.toBuffer());
            buffer.put((byte)32);
            buffer.put((byte)(48 + status / 100));
            buffer.put((byte)(48 + status % 100 / 10));
            buffer.put((byte)(48 + status % 10));
            buffer.put((byte)32);
            if (reason != null) {
                buffer.put(StringUtil.getBytes((String)reason, (String)"UTF-8"));
            }
            buffer.put(SipGrammar.CRLF);
        }
    }

    private void generateHeaders(ByteBuffer buffer, SipFields sipFields, SipServletMessage.HeaderForm headerForm) {
        boolean contentLengthSet = false;
        if (sipFields != null) {
            for (SipFields.Field field : sipFields) {
                if (field.getHeader() == SipHeader.CONTENT_LENGTH) {
                    contentLengthSet = true;
                }
                field.putTo(buffer, headerForm);
            }
        }
        if (!contentLengthSet) {
            if (headerForm == SipServletMessage.HeaderForm.COMPACT) {
                buffer.put(CONTENT_LENGTH_0_COMPACT);
            } else {
                buffer.put(CONTENT_LENGTH_0);
            }
        }
        buffer.put(SipGrammar.CRLF);
    }

    public static void main(String[] args) {
    }

    static {
        int versionLength = SipVersion.SIP_2_0.toString().length();
        for (int i = 0; i < __responses.length; ++i) {
            SipStatus status = SipStatus.get(i);
            if (status == null) continue;
            String reason = status.getReason();
            byte[] line = new byte[versionLength + 5 + reason.length() + 2];
            SipVersion.SIP_2_0.toBuffer().get(line, 0, versionLength);
            line[versionLength + 0] = 32;
            line[versionLength + 1] = (byte)(48 + i / 100);
            line[versionLength + 2] = (byte)(48 + i % 100 / 10);
            line[versionLength + 3] = (byte)(48 + i % 10);
            line[versionLength + 4] = 32;
            for (int j = 0; j < reason.length(); ++j) {
                line[versionLength + 5 + j] = (byte)reason.charAt(j);
            }
            line[versionLength + 5 + reason.length()] = 13;
            line[versionLength + 6 + reason.length()] = 10;
            SipGenerator.__responses[i] = new PreparedResponse();
            SipGenerator.__responses[i]._reason = new byte[line.length - versionLength - 7];
            System.arraycopy(line, versionLength + 5, SipGenerator.__responses[i]._reason, 0, line.length - versionLength - 7);
            SipGenerator.__responses[i]._schemeCode = new byte[versionLength + 5];
            System.arraycopy(line, 0, SipGenerator.__responses[i]._schemeCode, 0, versionLength + 5);
            SipGenerator.__responses[i]._responseLine = line;
        }
    }

    private static class PreparedResponse {
        byte[] _reason;
        byte[] _schemeCode;
        byte[] _responseLine;

        private PreparedResponse() {
        }
    }
}

