/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import org.cipango.sip.AddressImpl;
import org.cipango.sip.ParameterableImpl;
import org.cipango.sip.SipHeader;
import org.cipango.sip.Via;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.StringUtil;

public class SipFields
implements Iterable<Field> {
    private final StringMap<Field> _map = new StringMap(true);

    public SipFields() {
    }

    public SipFields(SipFields other) {
        this._map.putAll(other._map);
    }

    public Field getField(SipHeader header) {
        return (Field)this._map.get(header.toString());
    }

    public Field getField(String name) {
        return (Field)this._map.get(name);
    }

    public Field getField(SipHeader header, String name) {
        if (header != null) {
            name = header.toString();
        }
        return this.getField(name);
    }

    public boolean containsKey(String name) {
        return this._map.containsKey((Object)name);
    }

    public String getString(String name) {
        return this.getString(null, SipHeader.getFormattedName(name));
    }

    public String getString(SipHeader header) {
        return this.getString(header, null);
    }

    public String getString(SipHeader header, String name) {
        Field field;
        if (header != null) {
            name = header.toString();
        }
        return (field = this.getField(name)) == null ? null : field.getValue().toString();
    }

    public void addString(String name, String value, boolean first) throws IllegalArgumentException {
        this.add(name, value, first);
    }

    public void add(String name, Object value, boolean first) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        Field field = new Field(name, value);
        Field f = (Field)this._map.get(name);
        if (f == null) {
            this._map.put(name, (Object)field);
        } else if (first) {
            field._next = f;
            this._map.put(name, (Object)field);
        } else {
            while (f._next != null) {
                f = f._next;
            }
            f._next = field;
        }
    }

    public void add(String name, String value) throws IllegalArgumentException {
        name = SipHeader.getFormattedName(name);
        this.addString(name, value, false);
    }

    public Object get(SipHeader header) {
        Field field = this.getField(header);
        return field == null ? null : field.getValue();
    }

    public void set(String name, Object value) {
        name = SipHeader.getFormattedName(name);
        this._map.put(name, (Object)new Field(name, value));
    }

    public void set(SipHeader header, Object value) {
        this.set(header.asString(), value);
    }

    public Object removeFirst(SipHeader header) {
        Field field = this.getField(header);
        if (field == null) {
            return null;
        }
        Field next = field._next;
        if (next != null) {
            this._map.put(next._name, (Object)next);
        } else {
            this._map.remove(field._name);
        }
        return field._value;
    }

    public void remove(String name) {
        this._map.remove(name);
    }

    public void copy(SipFields source, SipHeader header) {
        Field field = source.getField(header);
        if (field != null) {
            this._map.put(field._name, (Object)this.copy(field));
        }
    }

    private Field copy(Field field) {
        Field previous = null;
        Field first = null;
        SipHeader header = field._header;
        while (field != null) {
            Object o = field.getValue();
            switch (header.getType()) {
                case VIA: {
                    o = ((Via)o).clone();
                    break;
                }
                case ADDRESS: {
                    o = ((Address)o).clone();
                    break;
                }
                case PARAMETERABLE: {
                    o = ((Parameterable)o).clone();
                }
            }
            Field f = new Field(header, o);
            if (previous != null) {
                previous._next = f;
            } else {
                first = f;
            }
            field = field._next;
            previous = f;
        }
        return first;
    }

    public ListIterator<String> getValues(String name) {
        Field field = this.getField(SipHeader.getFormattedName(name));
        return new FieldIterator<String>(field){

            @Override
            public String getValue() {
                return this._f.getValue().toString();
            }
        };
    }

    public long getLong(SipHeader header) {
        Field field = this.getField(header.asString());
        if (field != null) {
            return Long.parseLong(field.getValue().toString());
        }
        return -1L;
    }

    public Iterator<String> getNames() {
        return this._map.keySet().iterator();
    }

    public ListIterator<Parameterable> getParameterableValues(SipHeader header, String name) throws ServletParseException {
        Field field;
        Field f = field = this.getField(header, name);
        while (f != null) {
            f.asParameterable();
            f = f._next;
        }
        return new FieldIterator<Parameterable>(field){

            @Override
            public Parameterable getValue() {
                return (Parameterable)this._f.getValue();
            }
        };
    }

    public ListIterator<Address> getAddressValues(SipHeader header, String name) throws ServletParseException {
        Field field;
        Field f = field = this.getField(header, name);
        while (f != null) {
            f.asAddress();
            f = f._next;
        }
        return new FieldIterator<Address>(field){

            @Override
            public Address getValue() {
                return (Address)this._f.getValue();
            }
        };
    }

    @Override
    public Iterator<Field> iterator() {
        return this._map.values().iterator();
    }

    abstract class FieldIterator<E>
    implements ListIterator<E> {
        Field _f;
        Field _first;
        int _index = 0;

        public FieldIterator(Field field) {
            this._f = field;
            this._first = field;
        }

        @Override
        public boolean hasNext() {
            return this._f != null;
        }

        @Override
        public E next() {
            if (this._f == null) {
                throw new NoSuchElementException();
            }
            E value = this.getValue();
            this._f = this._f._next;
            ++this._index;
            return value;
        }

        public abstract E getValue();

        @Override
        public boolean hasPrevious() {
            return this._index > 0;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            --this._index;
            this._f = this._first;
            for (int i = 0; i < this._index; ++i) {
                this._f = this._f._next;
            }
            return this.getValue();
        }

        @Override
        public int nextIndex() {
            return this._index;
        }

        @Override
        public int previousIndex() {
            return this._index - 1;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Field {
        private SipHeader _header;
        private String _name;
        private Object _value;
        private Field _next;

        public Field(SipHeader header, Object value) {
            this._header = header;
            this._value = value;
            this._name = this._header.toString();
        }

        public Field(String name, Object value) {
            this._header = (SipHeader)((Object)SipHeader.CACHE.get(name));
            this._name = this._header == null ? name : this._header.toString();
            this._value = value;
        }

        public SipHeader getHeader() {
            return this._header;
        }

        public Object getValue() {
            return this._value;
        }

        public Address asAddress() throws ServletParseException {
            if (!(this._value instanceof Address)) {
                AddressImpl value = new AddressImpl(this._value.toString());
                try {
                    value.parse();
                }
                catch (ParseException e) {
                    throw new ServletParseException((Throwable)e);
                }
                this._value = value;
            }
            return (Address)this._value;
        }

        public Parameterable asParameterable() throws ServletParseException {
            if (!(this._value instanceof Parameterable)) {
                ParameterableImpl value;
                try {
                    value = new ParameterableImpl(this._value.toString());
                }
                catch (ParseException e) {
                    throw new ServletParseException((Throwable)e);
                }
                this._value = value;
            }
            return (Parameterable)this._value;
        }

        public void putTo(ByteBuffer buffer, SipServletMessage.HeaderForm headerForm) {
            if (this._header != null) {
                if (headerForm == SipServletMessage.HeaderForm.COMPACT) {
                    Byte compact = SipHeader.REVERSE_COMPACT_CACHE.get((Object)this._header);
                    if (compact != null) {
                        buffer.put(compact);
                        buffer.put((byte)58);
                        buffer.put((byte)32);
                    } else {
                        buffer.put(this._header.getBytesColonSpace());
                    }
                } else {
                    buffer.put(this._header.getBytesColonSpace());
                }
            } else {
                buffer.put(StringUtil.getUtf8Bytes((String)this._name));
                buffer.put((byte)58);
                buffer.put((byte)32);
            }
            Field next = this._next;
            buffer.put(StringUtil.getBytes((String)this._value.toString(), (String)"UTF-8"));
            if (this._header != null && this._header.isMerge()) {
                while (next != null) {
                    buffer.put((byte)44);
                    buffer.put((byte)32);
                    buffer.put(StringUtil.getUtf8Bytes((String)next._value.toString()));
                    next = next._next;
                }
            }
            BufferUtil.putCRLF((ByteBuffer)buffer);
            if (next != null) {
                next.putTo(buffer, headerForm);
            }
        }

        public String toString() {
            return String.valueOf(this._value);
        }
    }
}

