/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.text.ParseException;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.cipango.util.StringScanner;
import org.cipango.util.StringUtil;
import org.eclipse.jetty.util.StringMap;

public class Parameters {
    private static final BitSet END_PNAME = StringUtil.toBitSet((String)" \t;=");
    private static final BitSet END_PVALUE = StringUtil.toBitSet((String)" \t;");
    private Map<String, String> _parameters;

    public String getParameter(String name) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        return this._parameters != null ? this._parameters.get(name) : null;
    }

    public Iterator<String> getParameterNames() {
        if (this._parameters == null) {
            return Collections.emptyIterator();
        }
        return Collections.unmodifiableSet(this._parameters.keySet()).iterator();
    }

    public Set<Map.Entry<String, String>> getParameters() {
        if (this._parameters == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this._parameters.entrySet());
    }

    public void removeParameter(String name) {
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        if (this._parameters != null) {
            this._parameters.remove(name);
        }
    }

    public void setParameter(String name, String value) {
        if (this._parameters == null) {
            this._parameters = new StringMap(true);
        }
        this._parameters.put(name, value);
    }

    public void parameterParsed(String name, String value) {
        this.setParameter(name, value);
    }

    public void parseParameters(StringScanner scanner) throws ParseException {
        while (!scanner.eof()) {
            int start = scanner.position();
            scanner.skipWhitespace();
            if (!scanner.eof() && scanner.peekChar() == ';') {
                scanner.skipChar().skipWhitespace();
                String key = scanner.readTo(END_PNAME);
                if (key.length() <= 0) continue;
                String value = "";
                scanner.skipWhitespace();
                if (!scanner.eof() && scanner.peekChar() == '=') {
                    scanner.skipChar().skipWhitespace();
                    value = !scanner.eof() && scanner.peekChar() == '\"' ? StringUtil.unquote((String)scanner.readQuoted()) : scanner.readTo(END_PVALUE);
                }
                if (!StringUtil.isToken((String)key)) {
                    throw new ParseException("Invalid parameter name [" + key + "]", scanner.position());
                }
                this.parameterParsed(key, value);
                continue;
            }
            scanner.position(start);
            return;
        }
    }

    public void appendParameters(StringBuilder appendable) {
        if (this._parameters != null) {
            for (String name : this._parameters.keySet()) {
                String value = this._parameters.get(name);
                appendable.append(';');
                appendable.append(name);
                if (value == null || "".equals(value)) continue;
                appendable.append('=');
                appendable.append(StringUtil.quoteIfNeeded((String)value, (BitSet)StringUtil.TOKEN_BS));
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        Parameters parameters = (Parameters)super.clone();
        parameters._parameters = null;
        for (Map.Entry<String, String> entry : this.getParameters()) {
            parameters.setParameter(entry.getKey(), entry.getValue());
        }
        return parameters;
    }
}

