/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Map;
import javax.servlet.sip.Parameterable;
import org.cipango.sip.Parameters;
import org.cipango.util.StringScanner;

public class ParameterableImpl
extends Parameters
implements Parameterable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String _value;

    public ParameterableImpl() {
    }

    public ParameterableImpl(String s) throws ParseException {
        this.parse(s);
    }

    private void parse(String s) throws ParseException {
        StringScanner scanner = new StringScanner(s);
        scanner.skipToChar(';');
        if (scanner.eof()) {
            this._value = s;
        } else {
            this._value = scanner.skipBackWhitespace().readFromMark();
            this.parseParameters(scanner);
        }
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append(this._value);
        this.appendParameters(sb);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Parameterable)) {
            return false;
        }
        Parameterable p = (Parameterable)o;
        if (!this._value.equals(p.getValue())) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.getParameters()) {
            String otherValue = p.getParameter(entry.getKey());
            if (otherValue == null || entry.getValue().equalsIgnoreCase(otherValue)) continue;
            return false;
        }
        return true;
    }

    public Parameterable clone() {
        try {
            return new ParameterableImpl(this.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(in.readUTF());
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }
}

