/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import javax.servlet.sip.ServletParseException;
import org.cipango.util.StringUtil;

public class CSeq
implements Cloneable {
    private long _number;
    private String _method;
    private String _cseq;

    public CSeq(String cseq) throws ServletParseException {
        this._cseq = cseq;
        this.parse();
    }

    private void parse() throws ServletParseException {
        int index = this._cseq.indexOf(32);
        if (index < 0) {
            throw new ServletParseException("Invalid CSeq header: " + this._cseq);
        }
        String sNumber = this._cseq.substring(0, index).trim();
        try {
            this._number = Long.parseLong(sNumber);
        }
        catch (NumberFormatException _) {
            throw new ServletParseException("Invalid CSeq number: " + sNumber);
        }
        this._method = this._cseq.substring(index + 1).trim();
        if (!StringUtil.isToken((String)this._method)) {
            throw new ServletParseException("Invalid CSeq method: " + this._method);
        }
    }

    public long getNumber() {
        return this._number;
    }

    public String getMethod() {
        return this._method;
    }

    public String toString() {
        return this._cseq;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

