/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import org.cipango.sip.Authenticate;
import org.cipango.sip.DigestAuthenticator;
import org.cipango.util.StringUtil;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.security.Credential;

public class Authorization
extends Credential {
    static StringMap<Param> CACHE = new StringMap(true);
    private static Random __random;
    private EnumMap<Param, String> _params = new EnumMap(Param.class);
    private HashMap<String, String> _unknownParams;
    private String _scheme;
    private String _method;

    public Authorization(Authenticate authenticate, String username, String password, String uri, String method) {
        this._params.put(Param.USERNAME, username);
        this._params.put(Param.REALM, authenticate.getRealm());
        this._params.put(Param.NONCE, authenticate.getNonce());
        this._params.put(Param.ALGORITHM, authenticate.getAlgorithm());
        this._scheme = authenticate.getScheme();
        if (authenticate.getQop() != null) {
            this._params.put(Param.CNONCE, this.newCNonce());
            StringTokenizer st = new StringTokenizer(authenticate.getQop(), ",");
            boolean first = true;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (!first && !token.equalsIgnoreCase("auth")) continue;
                this._params.put(Param.QOP, token);
                first = false;
            }
            this._params.put(Param.NONCE_COUNT, "00000001");
        }
        this._params.put(Param.OPAQUE, authenticate.getOpaque());
        this._params.put(Param.DIGEST_URI, uri);
        this._params.put(Param.RESPONSE, this.getCalculatedResponse(password, method));
    }

    public Authorization(String auth) {
        int beginIndex = auth.indexOf(32);
        this._scheme = auth.substring(0, beginIndex).trim();
        while (beginIndex > 0) {
            int endIndex = auth.indexOf(61, beginIndex);
            String name = auth.substring(beginIndex, endIndex).trim();
            if (auth.charAt(endIndex + 1) == '\"') {
                beginIndex = endIndex + 2;
                endIndex = auth.indexOf(34, beginIndex);
            } else {
                beginIndex = endIndex + 1;
                if ((endIndex = auth.indexOf(44, beginIndex)) == -1) {
                    endIndex = auth.length();
                }
            }
            String value = auth.substring(beginIndex, endIndex);
            this.setParameter(name, value);
            beginIndex = auth.indexOf(44, endIndex) + 1;
        }
    }

    public String getCalculatedResponse(String password, String method) {
        return new DigestAuthenticator().calculateResponse(this, password, method);
    }

    public void setParameter(String name, String value) {
        Param param = (Param)((Object)CACHE.get(name));
        if (param != null) {
            this._params.put(param, value);
        } else {
            if (this._unknownParams == null) {
                this._unknownParams = new HashMap();
            }
            this._unknownParams.put(name, value);
        }
    }

    public String getAlgorithm() {
        return this._params.get((Object)Param.ALGORITHM);
    }

    public String getCNonce() {
        return this._params.get((Object)Param.CNONCE);
    }

    public String getNonce() {
        return this._params.get((Object)Param.NONCE);
    }

    public void setNonce(String nonce) {
        this._params.put(Param.NONCE, nonce);
    }

    public String getNonceCount() {
        return this._params.get((Object)Param.NONCE_COUNT);
    }

    public String getOpaque() {
        return this._params.get((Object)Param.OPAQUE);
    }

    public void setOpaque(String opaque) {
        this._params.put(Param.OPAQUE, opaque);
    }

    public String getQop() {
        return this._params.get((Object)Param.QOP);
    }

    public String getRealm() {
        return this._params.get((Object)Param.REALM);
    }

    public void setRealm(String realm) {
        this._params.put(Param.REALM, realm);
    }

    public String getResponse() {
        return this._params.get((Object)Param.RESPONSE);
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getUri() {
        return this._params.get((Object)Param.DIGEST_URI);
    }

    public String getUsername() {
        return this._params.get((Object)Param.USERNAME);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme()).append(' ');
        boolean first = true;
        for (Param p : Param.values()) {
            String value = this._params.get((Object)p);
            if (value == null) continue;
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(p.toString());
            if (p == Param.NONCE_COUNT) {
                sb.append("=").append(value);
                continue;
            }
            sb.append("=\"").append(value).append('\"');
        }
        return sb.toString();
    }

    public boolean check(Object credentials) {
        if (credentials instanceof char[]) {
            credentials = new String((char[])credentials);
        }
        String password = credentials instanceof String ? (String)credentials : credentials.toString();
        return this.getResponse().equals(this.getCalculatedResponse(password, this._method));
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    private String newCNonce() {
        long r = __random.nextInt();
        return StringUtil.toBase62String2((long)(r < 0L ? -r : r));
    }

    static {
        for (Param p : Param.values()) {
            CACHE.put(p.toString(), (Object)p);
        }
        __random = new Random();
    }

    static enum Param {
        USERNAME("username"),
        REALM("realm"),
        NONCE("nonce"),
        DIGEST_URI("uri"),
        RESPONSE("response"),
        ALGORITHM("algorithm"),
        CNONCE("cnonce"),
        OPAQUE("opaque"),
        QOP("qop"),
        NONCE_COUNT("nc");

        private String _string;

        private Param(String s) {
            this._string = s;
        }

        public String toString() {
            return this._string;
        }
    }
}

