/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.util.EnumMap;
import java.util.HashMap;
import org.eclipse.jetty.util.StringMap;

public class Authenticate {
    static StringMap<Param> CACHE = new StringMap(true);
    private EnumMap<Param, String> _params = new EnumMap(Param.class);
    private HashMap<String, String> _unknownParams;
    private String _scheme;

    public Authenticate(String auth) {
        int beginIndex = auth.indexOf(32);
        this._scheme = auth.substring(0, beginIndex).trim();
        while (beginIndex > 0) {
            int endIndex = auth.indexOf(61, beginIndex);
            String name = auth.substring(beginIndex, endIndex).trim();
            if (auth.charAt(endIndex + 1) == '\"') {
                beginIndex = endIndex + 2;
                endIndex = auth.indexOf(34, beginIndex);
            } else {
                beginIndex = endIndex + 1;
                if ((endIndex = auth.indexOf(44, beginIndex)) == -1) {
                    endIndex = auth.length();
                }
            }
            String value = auth.substring(beginIndex, endIndex);
            this.setParameter(name, value);
            beginIndex = auth.indexOf(44, endIndex) + 1;
        }
    }

    public Authenticate(String scheme, String realm, String nonce, boolean stale, String algorithm) {
        this._scheme = scheme;
        this._params.put(Param.REALM, realm);
        this._params.put(Param.NONCE, nonce);
        this._params.put(Param.ALGORITHM, algorithm);
        if (stale) {
            this._params.put(Param.STALE, "true");
        }
    }

    public String getParameter(String name) {
        Param param = (Param)((Object)CACHE.get(name));
        if (param != null) {
            return this._params.get((Object)param);
        }
        if (this._unknownParams != null) {
            return this._unknownParams.get(name);
        }
        return null;
    }

    public void setParameter(String name, String value) {
        Param param = (Param)((Object)CACHE.get(name));
        if (param != null) {
            this._params.put(param, value);
        } else {
            if (this._unknownParams == null) {
                this._unknownParams = new HashMap();
            }
            this._unknownParams.put(name, value);
        }
    }

    public String getAlgorithm() {
        return this._params.get((Object)Param.ALGORITHM);
    }

    public String getDomain() {
        return this._params.get((Object)Param.DOMAIN);
    }

    public String getNonce() {
        return this._params.get((Object)Param.NONCE);
    }

    public String getOpaque() {
        return this._params.get((Object)Param.OPAQUE);
    }

    public String getQop() {
        return this._params.get((Object)Param.QOP);
    }

    public String getRealm() {
        return this._params.get((Object)Param.REALM);
    }

    public String getScheme() {
        return this._scheme;
    }

    public boolean isStale() {
        return "true".equalsIgnoreCase(this._params.get((Object)Param.STALE));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme()).append(' ');
        boolean first = true;
        for (Param p : Param.values()) {
            String value = this._params.get((Object)p);
            if (value == null) continue;
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(p.toString()).append("=\"").append(value).append('\"');
        }
        if (this._unknownParams != null) {
            for (String key : this._unknownParams.keySet()) {
                sb.append(',');
                sb.append(key).append("=\"").append(this._unknownParams.get(key)).append('\"');
            }
        }
        return sb.toString();
    }

    static {
        for (Param p : Param.values()) {
            CACHE.put(p.toString(), (Object)p);
        }
    }

    public static enum Param {
        REALM("realm"),
        DOMAIN("domain"),
        NONCE("nonce"),
        OPAQUE("opaque"),
        STALE("stale"),
        ALGORITHM("algorithm"),
        QOP("qop");

        private String _string;

        private Param(String s) {
            this._string = s;
        }

        public String toString() {
            return this._string;
        }
    }
}

