/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.sip;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.sip.Address;
import javax.servlet.sip.URI;
import org.cipango.sip.Modifiable;
import org.cipango.sip.Parameters;
import org.cipango.sip.URIFactory;
import org.cipango.util.StringScanner;
import org.cipango.util.StringUtil;

public class AddressImpl
extends Parameters
implements Address,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TAG = "tag";
    private static final BitSet DISPLAY_NAME_BS = StringUtil.toBitSet((String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.!%*_+`'~ ");
    private String _displayName;
    private String _string;
    private boolean _wildcard;
    private String _tag;
    private URI _uri;

    public AddressImpl(String string) {
        this._string = string;
    }

    public AddressImpl(String string, boolean parse) throws ParseException {
        this._string = string;
        if (parse) {
            this.parse();
        }
    }

    public AddressImpl(URI uri) {
        this._uri = uri;
    }

    public String getTag() {
        return this._tag;
    }

    public String getTag2() {
        int m;
        int i;
        for (i = m = this._string.indexOf("tag=") + 4; i < this._string.length() && "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.!%*_+`'~".indexOf(this._string.charAt(i)) != -1; ++i) {
        }
        return this._string.substring(m, i);
    }

    public void parse() throws ParseException {
        String s = this._string;
        this.parse(this._string, true);
        this._string = s;
    }

    private void parse(String address, boolean parseParam) throws ParseException {
        StringScanner scanner = new StringScanner(address);
        int m = scanner.skipWhitespace().position();
        if (scanner.peekChar() == '*') {
            this._wildcard = true;
            return;
        }
        String suri = null;
        boolean laquote = false;
        if (scanner.peekChar() == '\"') {
            this._displayName = StringUtil.unquote((String)scanner.readQuoted());
            scanner.skipToChar('<').readChar('<').mark();
            laquote = true;
        } else if (scanner.peekChar() == '<') {
            scanner.readChar('<').mark();
            laquote = true;
        } else {
            scanner.skipToChar('<');
            if (scanner.eof()) {
                scanner.reset();
            } else {
                laquote = true;
                scanner.skipBackWhitespace();
                this._displayName = scanner.readFromMark();
                scanner.skipToChar('<').skipChar();
            }
        }
        scanner.skipWhitespace().mark();
        if (laquote) {
            suri = scanner.skipToChar('>').skipBackWhitespace().readFromMark();
            scanner.skipToChar('>').readChar('>');
        } else {
            suri = scanner.skipToChar(';').skipBackWhitespace().readFromMark();
        }
        this._uri = URIFactory.parseURI(suri);
        if (parseParam) {
            this.parseParameters(scanner);
        }
    }

    @Override
    public String getParameter(String name) {
        if (TAG.equalsIgnoreCase(name)) {
            return this._tag;
        }
        return super.getParameter(name);
    }

    @Override
    public Iterator<String> getParameterNames() {
        TagIterator it = super.getParameterNames();
        if (this._tag != null) {
            it = new TagIterator(it);
        }
        return it;
    }

    @Override
    public Set<Map.Entry<String, String>> getParameters() {
        Set<Map.Entry<String, String>> set = super.getParameters();
        if (this._tag != null) {
            set = new HashSet<Map.Entry<String, String>>(set);
            set.add(new AbstractMap.SimpleEntry<String, String>(TAG, this._tag));
            set = Collections.unmodifiableSet(set);
        }
        return set;
    }

    public String getValue() {
        return this.getValueBuffer().toString();
    }

    @Override
    public void removeParameter(String name) {
        if (TAG.equalsIgnoreCase(name)) {
            this._tag = null;
        } else {
            super.removeParameter(name);
        }
        this._string = null;
    }

    @Override
    public void setParameter(String name, String value) {
        this._string = null;
        if (name.equalsIgnoreCase(TAG)) {
            this._tag = value;
        } else {
            super.setParameter(name, value);
        }
        this._string = null;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new NullPointerException("Null value");
        }
        try {
            this._displayName = null;
            this._wildcard = false;
            this._string = null;
            this._uri = null;
            this.parse(value, false);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public int getExpires() {
        String expires = this.getParameter("expires");
        if (expires != null) {
            try {
                return Integer.parseInt(expires);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public float getQ() {
        String q = this.getParameter("q");
        if (q != null) {
            try {
                return Float.parseFloat(q);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1.0f;
    }

    public URI getURI() {
        return this._uri;
    }

    public boolean isWildcard() {
        return this._wildcard;
    }

    public void setDisplayName(String name) {
        this._displayName = name;
        this._string = null;
    }

    public void setExpires(int seconds) {
        if (seconds < 0) {
            this.removeParameter("expires");
        } else {
            this.setParameter("expires", Integer.toString(seconds));
        }
    }

    public void setQ(float q) {
        if (q == -1.0f) {
            this.removeParameter("q");
        } else {
            if (q < 0.0f || q > 1.0f) {
                throw new IllegalArgumentException("Invalid q value:" + q);
            }
            this.setParameter("q", String.valueOf(q));
        }
    }

    public void setURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("Null URI");
        }
        this._uri = uri;
        this._string = null;
    }

    public String toString() {
        boolean uriModified;
        if (this.isWildcard()) {
            return "*";
        }
        boolean bl = uriModified = !(this._uri instanceof Modifiable) || ((Modifiable)this._uri).hasBeenModified();
        if (this._string == null || uriModified) {
            StringBuilder buffer = this.getValueBuffer();
            if (this._tag != null) {
                buffer.append(";tag=");
                buffer.append(this._tag);
            }
            this.appendParameters(buffer);
            this._string = buffer.toString();
        }
        return this._string;
    }

    public StringBuilder getValueBuffer() {
        if (this.isWildcard()) {
            return new StringBuilder("*");
        }
        StringBuilder buffer = new StringBuilder(64);
        if (this._displayName != null) {
            buffer.append(StringUtil.quoteIfNeeded((String)this._displayName, (BitSet)DISPLAY_NAME_BS)).append(' ');
        }
        buffer.append('<');
        buffer.append(this._uri.toString());
        buffer.append('>');
        return buffer;
    }

    public Address clone() {
        try {
            AddressImpl clone = (AddressImpl)super.clone();
            if (this._uri != null) {
                clone._uri = this._uri.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (this.isWildcard()) {
            return other.isWildcard();
        }
        if (other.isWildcard()) {
            return this.isWildcard();
        }
        if (!this._uri.equals((Object)other.getURI())) {
            return false;
        }
        if (!StringUtil.equals((String)this._tag, (String)other.getParameter(TAG))) {
            return false;
        }
        for (Map.Entry<String, String> entry : super.getParameters()) {
            String otherValue = other.getParameter(entry.getKey());
            if (otherValue == null || entry.getValue().equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.toString());
        out.writeObject(this._uri);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this._string = in.readUTF();
            this.parse();
            this._uri = (URI)in.readObject();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    class TagIterator
    implements Iterator<String> {
        private Iterator<String> _it;
        private boolean _tagRead = false;
        private boolean _tagReading = true;

        public TagIterator(Iterator<String> it) {
            this._it = it;
        }

        @Override
        public boolean hasNext() {
            return this._it.hasNext() || !this._tagRead;
        }

        @Override
        public String next() {
            if (!this._tagRead) {
                this._tagRead = true;
                return AddressImpl.TAG;
            }
            this._tagReading = false;
            return this._it.next();
        }

        @Override
        public void remove() {
            if (this._tagReading) {
                AddressImpl.this._tag = null;
            } else {
                this._it.remove();
            }
        }
    }
}

