/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.sip;

import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

public abstract class SipServlet
extends GenericServlet {
    public static final String SIP_FACTORY = "javax.servlet.sip.SipFactory";
    public static final String TIMER_SERVICE = "javax.servlet.sip.TimerService";
    public static final String SUPPORTED = "javax.servlet.sip.supported";
    public static final String SUPPORTED_RFCs = "javax.servlet.sip.supportedRfcs";
    public static final String OUTBOUND_INTERFACES = "javax.servlet.sip.outboundInterfaces";
    public static final String SIP_SESSIONS_UTIL = "javax.servlet.sip.SipSessionsUtil";
    public static final String PRACK_SUPPORTED = "javax.servlet.sip.100rel";

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (servletRequest != null) {
            this.doRequest((SipServletRequest)servletRequest);
        } else {
            this.doResponse((SipServletResponse)servletResponse);
        }
    }

    protected void doRequest(SipServletRequest sipServletRequest) throws ServletException, IOException {
        String string = sipServletRequest.getMethod();
        if ("INVITE".equals(string)) {
            this.doInvite(sipServletRequest);
        } else if ("ACK".equals(string)) {
            this.doAck(sipServletRequest);
        } else if ("OPTIONS".equals(string)) {
            this.doOptions(sipServletRequest);
        } else if ("BYE".equals(string)) {
            this.doBye(sipServletRequest);
        } else if ("CANCEL".equals(string)) {
            this.doCancel(sipServletRequest);
        } else if ("REGISTER".equals(string)) {
            this.doRegister(sipServletRequest);
        } else if ("SUBSCRIBE".equals(string)) {
            this.doSubscribe(sipServletRequest);
        } else if ("NOTIFY".equals(string)) {
            this.doNotify(sipServletRequest);
        } else if ("MESSAGE".equals(string)) {
            this.doMessage(sipServletRequest);
        } else if ("INFO".equals(string)) {
            this.doInfo(sipServletRequest);
        } else if ("UPDATE".equals(string)) {
            this.doUpdate(sipServletRequest);
        } else if ("REFER".equals(string)) {
            this.doRefer(sipServletRequest);
        } else if ("PUBLISH".equals(string)) {
            this.doPublish(sipServletRequest);
        } else if ("PRACK".equals(string)) {
            this.doPrack(sipServletRequest);
        } else if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doInvite(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doAck(SipServletRequest sipServletRequest) throws ServletException, IOException {
    }

    protected void doOptions(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doBye(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doCancel(SipServletRequest sipServletRequest) throws ServletException, IOException {
    }

    protected void doRegister(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doSubscribe(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doNotify(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doMessage(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doInfo(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doPrack(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doUpdate(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doRefer(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    protected void doPublish(SipServletRequest sipServletRequest) throws ServletException, IOException {
        if (sipServletRequest.isInitial()) {
            this.notHandled(sipServletRequest);
        }
    }

    private void notHandled(SipServletRequest sipServletRequest) throws IOException {
        SipServletResponse sipServletResponse = sipServletRequest.createResponse(500, "Request not handled by app");
        sipServletResponse.send();
    }

    protected void doResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
        int n = sipServletResponse.getStatus();
        if (n < 200) {
            this.doProvisionalResponse(sipServletResponse);
        } else if (n < 300) {
            this.doSuccessResponse(sipServletResponse);
        } else if (sipServletResponse.isBranchResponse()) {
            this.doBranchResponse(sipServletResponse);
        } else if (n < 400) {
            this.doRedirectResponse(sipServletResponse);
        } else {
            this.doErrorResponse(sipServletResponse);
        }
    }

    protected void doProvisionalResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
    }

    protected void doSuccessResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
    }

    protected void doRedirectResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
    }

    protected void doErrorResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
    }

    protected void doBranchResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
    }

    public void log(String string) {
        this.getServletContext().log(string);
    }

    public void log(String string, Throwable throwable) {
        this.getServletContext().log(string, throwable);
    }
}

