/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.util.ArrayList;
import java.util.List;

public class CommandLineBuilder {
    private List<String> args = new ArrayList<String>();

    public CommandLineBuilder(String bin) {
        this.args.add(bin);
    }

    public void addArg(String arg) {
        if (arg != null) {
            this.args.add(CommandLineBuilder.quote(arg));
        }
    }

    public void addEqualsArg(String name, String value) {
        if (value != null && value.length() > 0) {
            this.args.add(CommandLineBuilder.quote(name + "=" + value));
        } else {
            this.args.add(CommandLineBuilder.quote(name));
        }
    }

    public void addRawArg(String arg) {
        if (arg != null) {
            this.args.add(arg);
        }
    }

    public List<String> getArgs() {
        return this.args;
    }

    public static String quote(String arg) {
        boolean needsQuoting;
        boolean bl = needsQuoting = arg.indexOf(32) >= 0 || arg.indexOf(34) >= 0;
        if (!needsQuoting) {
            return arg;
        }
        StringBuilder buf = new StringBuilder();
        boolean escaped = false;
        boolean quoted = false;
        for (char c : arg.toCharArray()) {
            if (!(quoted || escaped || c != '\"' && c != ' ')) {
                buf.append("\\");
            }
            if (!escaped && c == '\'') {
                quoted = !quoted;
            }
            escaped = c == '\\';
            buf.append(c);
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean delim = false;
        for (String arg : this.args) {
            if (delim) {
                buf.append(' ');
            }
            buf.append(CommandLineBuilder.quote(arg));
            delim = true;
        }
        return buf.toString();
    }
}

