/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.util;

import java.nio.ByteBuffer;

public abstract class BufferUtil {
    public static int getInt(ByteBuffer buffer) {
        return (buffer.get() & 0xFF) << 24 | (buffer.get() & 0xFF) << 16 | (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
    }

    public static ByteBuffer putInt(ByteBuffer buffer, int value) {
        buffer.put((byte)(value >> 24 & 0xFF));
        buffer.put((byte)(value >> 16 & 0xFF));
        buffer.put((byte)(value >> 8 & 0xFF));
        buffer.put((byte)(value & 0xFF));
        return buffer;
    }

    public static ByteBuffer pokeInt(ByteBuffer buffer, int index, int value) {
        buffer.put(index, (byte)(value >> 24 & 0xFF));
        buffer.put(index + 1, (byte)(value >> 16 & 0xFF));
        buffer.put(index + 2, (byte)(value >> 8 & 0xFF));
        buffer.put(index + 3, (byte)(value & 0xFF));
        return buffer;
    }

    public static ByteBuffer poke16(ByteBuffer buffer, int index, int val) {
        buffer.put(index, (byte)(val >> 8 & 0xFF));
        buffer.put(index + 1, (byte)(val & 0xFF));
        return buffer;
    }

    public static ByteBuffer put16(ByteBuffer buffer, int val) {
        buffer.put((byte)(val >> 8 & 0xFF));
        buffer.put((byte)(val & 0xFF));
        return buffer;
    }

    public static int get16(ByteBuffer buffer) {
        return (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
    }

    public static byte[] getBytes(ByteBuffer buffer, int size) {
        byte[] b = new byte[size];
        buffer.get(b);
        return b;
    }

    public static ByteBuffer ensureSpace(ByteBuffer buffer, int space) {
        if (buffer.remaining() < space) {
            ByteBuffer largerBuffer = ByteBuffer.allocate(buffer.capacity() + 100);
            largerBuffer.put(buffer);
            return largerBuffer;
        }
        return buffer;
    }

    public static int check16(String field, int value) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Invalid value: " + value + " for field " + field + ": must be an unsigned 16 bit");
        }
        return value;
    }

    public static int check8(String field, int value) {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Invalid value: " + value + " for field " + field + ": must be an unsigned 8 bit");
        }
        return value;
    }
}

