/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.section;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.cipango.dns.DnsMessage;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.Record;
import org.cipango.dns.util.BufferUtil;

public class ResourceRecordsSection
extends AbstractList<Record> {
    private List<Record> _records = new ArrayList<Record>();
    private DnsMessage _message;

    public ResourceRecordsSection(DnsMessage message) {
        this._message = message;
    }

    public void encode(ByteBuffer buffer) throws IOException {
        for (Record record : this._records) {
            this.getMessage().getCompression().encodeName(record.getName(), buffer);
            record.getType().encode(buffer);
            BufferUtil.put16(buffer, record.getDnsClass());
            BufferUtil.putInt(buffer, record.getTtl());
            int index = buffer.position();
            buffer.position(index + 2);
            record.doEncode(buffer, this.getMessage().getCompression());
            BufferUtil.poke16(buffer, index, buffer.position() - index - 2);
        }
    }

    public void decode(ByteBuffer buffer, int nbRecords) throws IOException {
        for (int i = 0; i < nbRecords; ++i) {
            Name name = this.getMessage().getCompression().decodeName(buffer);
            Type type = Type.getType(BufferUtil.get16(buffer));
            int clazz = BufferUtil.get16(buffer);
            Record record = type.newRecord();
            record.setName(name);
            record.setDnsClass(clazz);
            record.setTtl(BufferUtil.getInt(buffer));
            int dataLength = BufferUtil.get16(buffer);
            record.doDecode(buffer, this.getMessage().getCompression(), dataLength);
            this._records.add(record);
        }
    }

    @Override
    public void add(int index, Record record) {
        this._records.add(index, record);
    }

    @Override
    public int size() {
        return this._records.size();
    }

    @Override
    public Record get(int index) {
        return this._records.get(index);
    }

    public <T extends Record> T get(Class<T> clazz) {
        for (Record record : this._records) {
            if (!clazz.isAssignableFrom(record.getClass())) continue;
            return (T)record;
        }
        return null;
    }

    public DnsMessage getMessage() {
        return this._message;
    }

    public StringBuilder append(StringBuilder sb, String role) {
        if (!this.isEmpty()) {
            sb.append(role).append("\n");
            for (Record record : this._records) {
                sb.append("  ").append(record).append("\n");
            }
        }
        return sb;
    }
}

