/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.section;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.cipango.dns.DnsMessage;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.Record;
import org.cipango.dns.util.BufferUtil;

public class QuestionSection
extends AbstractList<Record> {
    private List<Record> _records = new ArrayList<Record>();
    private DnsMessage _message;

    public QuestionSection(DnsMessage message) {
        this._message = message;
    }

    public void encode(ByteBuffer buffer) throws IOException {
        for (Record record : this._records) {
            this.getMessage().getCompression().encodeName(record.getName(), buffer);
            record.getType().encode(buffer);
            BufferUtil.put16(buffer, record.getDnsClass());
        }
    }

    public void decode(ByteBuffer buffer) throws IOException {
        int nbRecord = this.getMessage().getHeaderSection().getQuestionRecords();
        for (int i = 0; i < nbRecord; ++i) {
            Name name = this.getMessage().getCompression().decodeName(buffer);
            Type type = Type.getType(BufferUtil.get16(buffer));
            int clazz = BufferUtil.get16(buffer);
            Record record = type.newRecord();
            record.setDnsClass(clazz);
            record.setName(name);
            this._records.add(record);
        }
    }

    @Override
    public int size() {
        return this._records.size();
    }

    @Override
    public void add(int index, Record record) {
        this._records.add(index, record);
    }

    @Override
    public Record get(int index) {
        return this._records.get(index);
    }

    public StringBuilder append(StringBuilder sb) {
        sb.append("Queries\n");
        for (Record record : this._records) {
            sb.append("  ").append(record).append("\n");
        }
        return sb;
    }

    public DnsMessage getMessage() {
        return this._message;
    }

    @Override
    public String toString() {
        return this._records.toString();
    }
}

