/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.section;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.dns.DnsMessage;
import org.cipango.dns.util.BufferUtil;

public class HeaderSection {
    private static final int RESPONSE_FLAG = 32768;
    private static final int AUTHORITATIVE_ANSWER_FLAG = 1024;
    private static final int TRUNCATION_FLAG = 512;
    private static final int RECURSION_DESIRED_FLAG = 256;
    private static final int RECURSION_AVAILABLE_FLAG = 128;
    private DnsMessage _message;
    private int _id;
    private OpCode _opCode;
    private boolean _authoritativeAnswer;
    private boolean _truncated;
    private boolean _recursionDesired = true;
    private boolean _recursionAvailable;
    private ResponseCode _responseCode;
    private int _questionRecords;
    private int _answerRecords;
    private int _authorityRecords;
    private int _additionalRecords;
    private boolean _response = false;

    public HeaderSection(DnsMessage message) {
        this._message = message;
    }

    public void encode(ByteBuffer buffer) throws IOException {
        BufferUtil.put16(buffer, this._id);
        int flags = 0;
        if (this._response) {
            flags |= 0x8000;
            if (this._authoritativeAnswer) {
                flags |= 0x400;
            }
            if (this._responseCode != null) {
                flags |= this._responseCode.ordinal();
            }
        }
        flags |= this._opCode.ordinal() << 11;
        if (this._truncated) {
            flags |= 0x200;
        }
        if (this._recursionDesired) {
            flags |= 0x100;
        }
        if (this._recursionAvailable) {
            flags |= 0x80;
        }
        BufferUtil.put16(buffer, flags);
        BufferUtil.put16(buffer, this.getMessage().getQuestionSection().size());
        BufferUtil.put16(buffer, this.getMessage().getAnswerSection().size());
        BufferUtil.put16(buffer, this.getMessage().getAuthoritySection().size());
        BufferUtil.put16(buffer, this.getMessage().getAdditionalSection().size());
    }

    public void decode(ByteBuffer buffer) throws IOException {
        this._id = BufferUtil.get16(buffer);
        int flags = BufferUtil.get16(buffer);
        this._response = (flags & 0x8000) == 32768;
        this._opCode = OpCode.get(flags >> 11 & 0xF);
        this._authoritativeAnswer = this._response && (flags & 0x400) == 1024;
        this._truncated = (flags & 0x200) == 512;
        this._recursionDesired = (flags & 0x100) == 256;
        boolean bl = this._recursionAvailable = (flags & 0x80) == 128;
        if (this._response) {
            this._responseCode = ResponseCode.get(flags & 0xF);
        }
        this._questionRecords = BufferUtil.get16(buffer);
        this._answerRecords = BufferUtil.get16(buffer);
        this._authorityRecords = BufferUtil.get16(buffer);
        this._additionalRecords = BufferUtil.get16(buffer);
    }

    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public OpCode getOpCode() {
        return this._opCode;
    }

    public void setOpCode(OpCode opCode) {
        this._opCode = opCode;
    }

    public boolean isAuthoritativeAnswer() {
        return this._authoritativeAnswer;
    }

    public void setAuthoritativeAnswer(boolean authoritativeAnswer) {
        this._authoritativeAnswer = authoritativeAnswer;
    }

    public boolean isTruncated() {
        return this._truncated;
    }

    public void setTruncated(boolean truncated) {
        this._truncated = truncated;
    }

    public boolean isRecursionDesired() {
        return this._recursionDesired;
    }

    public void setRecursionDesired(boolean recursionDesired) {
        this._recursionDesired = recursionDesired;
    }

    public boolean isRecursionAvailable() {
        return this._recursionAvailable;
    }

    public void setRecursionAvailable(boolean recursionAvailable) {
        this._recursionAvailable = recursionAvailable;
    }

    public ResponseCode getResponseCode() {
        return this._responseCode;
    }

    public void setResponseCode(ResponseCode responseCode) {
        this._responseCode = responseCode;
    }

    public int getQuestionRecords() {
        return this._questionRecords;
    }

    public int getAnswerRecords() {
        return this._answerRecords;
    }

    public int getAuthorityRecords() {
        return this._authorityRecords;
    }

    public int getAdditionalRecords() {
        return this._additionalRecords;
    }

    public DnsMessage getMessage() {
        return this._message;
    }

    public StringBuilder append(StringBuilder sb) {
        if (this._responseCode != null) {
            sb.append("Answer ").append(this._id).append(" ").append((Object)this._responseCode);
        } else {
            sb.append("Query ").append(this._id);
        }
        sb.append('\n');
        return sb;
    }

    public boolean isResponse() {
        return this._response;
    }

    public void setResponse(boolean response) {
        this._response = response;
    }

    public static enum OpCode {
        QUERY,
        IQUERY,
        STATUS;


        public static OpCode get(int value) throws IOException {
            for (OpCode code : OpCode.values()) {
                if (code.ordinal() != value) continue;
                return code;
            }
            throw new IOException("Could not found OpCode with value: " + value);
        }
    }

    public static enum ResponseCode {
        NO_ERROR,
        FORMAT_ERROR,
        SERVER_FAILURE,
        NAME_ERROR,
        NOT_IMPLEMEMENTED,
        REFUSED,
        CODE_6,
        CODE_7,
        CODE_8,
        CODE_9,
        CODE_10,
        CODE_11,
        CODE_12,
        CODE_13,
        CODE_14,
        CODE_15;


        public static ResponseCode get(int value) throws IOException {
            for (ResponseCode code : ResponseCode.values()) {
                if (code.ordinal() != value) continue;
                return code;
            }
            throw new IOException("Could not found ResponseCode with value: " + value);
        }
    }
}

