/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.dns.Compression;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.AdditionalName;
import org.cipango.dns.record.Record;
import org.cipango.dns.util.BufferUtil;

public class SrvRecord
extends Record
implements AdditionalName,
Comparable<SrvRecord> {
    private int _priority;
    private int _weight;
    private int _port;
    private Name _target;

    public SrvRecord() {
    }

    public SrvRecord(Name name) {
        this.setName(name);
    }

    public SrvRecord(String service, String protocol, String host) {
        this.setName(new Name("_" + service + "._" + protocol + "." + host));
    }

    @Override
    public Type getType() {
        return Type.SRV;
    }

    @Override
    public void doEncode(ByteBuffer b, Compression c) throws IOException {
        BufferUtil.put16(b, this._priority);
        BufferUtil.put16(b, this._weight);
        BufferUtil.put16(b, this._port);
        c.encodeName(this._target, b, true);
    }

    @Override
    public void doDecode(ByteBuffer b, Compression c, int dataLength) throws IOException {
        this._priority = BufferUtil.get16(b);
        this._weight = BufferUtil.get16(b);
        this._port = BufferUtil.get16(b);
        this._target = c.decodeName(b);
    }

    public int getPriority() {
        return this._priority;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public int getWeight() {
        return this._weight;
    }

    public void setWeight(int weight) {
        this._weight = weight;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public Name getTarget() {
        return this._target;
    }

    public void setTarget(Name target) {
        this._target = target;
    }

    @Override
    public String toString() {
        if (this._target == null) {
            return super.toString();
        }
        return super.toString() + " " + this._priority + " " + this._weight + " " + this._port + " " + this._target;
    }

    @Override
    public Name getAdditionalName() {
        return this._target;
    }

    @Override
    public boolean doEquals(Record record) {
        return this.compare(this._target, ((SrvRecord)record).getTarget()) && this._port == ((SrvRecord)record).getPort();
    }

    @Override
    public int compareTo(SrvRecord o) {
        int priority = this.getPriority() - o.getPriority();
        if (priority != 0) {
            return priority;
        }
        int weight = this.getWeight() * this.hashCode() - o.getWeight() * o.hashCode();
        if (weight != 0) {
            return weight;
        }
        return this.hashCode() - o.hashCode();
    }
}

