/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.dns.Compression;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.Record;
import org.cipango.dns.util.BufferUtil;

public class SoaRecord
extends Record {
    private Name _primaryNameServer;
    private Name _mailbox;
    private int _serial;
    private int _refresh;
    private int _retry;
    private int _expires;
    private int _minimumTtl;

    @Override
    public Type getType() {
        return Type.SOA;
    }

    @Override
    public void doEncode(ByteBuffer b, Compression c) throws IOException {
        c.encodeName(this._primaryNameServer, b);
        c.encodeName(this._mailbox, b);
        BufferUtil.putInt(b, this._serial);
        BufferUtil.putInt(b, this._refresh);
        BufferUtil.putInt(b, this._retry);
        BufferUtil.putInt(b, this._expires);
        BufferUtil.putInt(b, this._minimumTtl);
    }

    @Override
    public void doDecode(ByteBuffer b, Compression c, int dataLength) throws IOException {
        this._primaryNameServer = c.decodeName(b);
        this._mailbox = c.decodeName(b);
        this._serial = BufferUtil.getInt(b);
        this._refresh = BufferUtil.getInt(b);
        this._retry = BufferUtil.getInt(b);
        this._expires = BufferUtil.getInt(b);
        this._minimumTtl = BufferUtil.getInt(b);
    }

    public int getSerial() {
        return this._serial;
    }

    public int getRefresh() {
        return this._refresh;
    }

    public int getRetry() {
        return this._retry;
    }

    public int getExpires() {
        return this._expires;
    }

    public int getMinimumTtl() {
        return this._minimumTtl;
    }

    @Override
    public String toString() {
        if (this._primaryNameServer == null) {
            return super.toString();
        }
        return super.toString() + " mname " + this._primaryNameServer;
    }

    public Name getPrimaryNameServer() {
        return this._primaryNameServer;
    }

    public Name getMailbox() {
        return this._mailbox;
    }

    @Override
    public boolean doEquals(Record record) {
        return this.compare(this._primaryNameServer, ((SoaRecord)record).getPrimaryNameServer());
    }
}

