/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.dns.Compression;
import org.cipango.dns.DnsClass;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.util.BufferUtil;

public abstract class Record {
    private int _ttl;
    private Name _name;
    private int _class = DnsClass.IN;

    public abstract Type getType();

    public abstract void doEncode(ByteBuffer var1, Compression var2) throws IOException;

    public abstract void doDecode(ByteBuffer var1, Compression var2, int var3) throws IOException;

    public abstract boolean doEquals(Record var1);

    protected byte[] decodeCharacterString(ByteBuffer b) {
        byte length = b.get();
        return BufferUtil.getBytes(b, length);
    }

    protected void encodeCharacterString(ByteBuffer b, byte[] characterString) {
        b.put((byte)(characterString.length & 0xFF));
        b.put(characterString);
    }

    public int getTtl() {
        return this._ttl;
    }

    public void setTtl(int ttl) {
        this._ttl = ttl;
    }

    public Name getName() {
        return this._name;
    }

    public void setName(Name name) {
        this._name = name;
    }

    public int getDnsClass() {
        return this._class;
    }

    public void setDnsClass(int clazz) {
        this._class = clazz;
    }

    public String toString() {
        return this._name + ": type " + (Object)((Object)this.getType());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record record = (Record)o;
        if (record.getType() != this.getType()) {
            return false;
        }
        if (!this._name.equals(record.getName())) {
            return false;
        }
        if (this._class != record.getDnsClass()) {
            return false;
        }
        return this.doEquals(record);
    }

    protected boolean compare(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }
}

