/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.record;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.cipango.dns.Compression;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.Record;

public class PtrRecord
extends Record {
    private Name _prtdName;

    public PtrRecord() {
    }

    public PtrRecord(InetAddress address) {
        this.setName(PtrRecord.getReverseName(address));
    }

    public PtrRecord(Name name) {
        this.setName(name);
    }

    public static Name getReverseName(InetAddress address) {
        Name name;
        byte[] addr = address.getAddress();
        if (address instanceof Inet4Address) {
            name = new Name("in-addr.arpa");
            for (int i = 0; i < addr.length; ++i) {
                Name tmp = name;
                name = new Name(Integer.toString(addr[i] & 0xFF));
                name.setChild(tmp);
            }
        } else {
            name = new Name("ip6.arpa");
            for (int i = 0; i < addr.length; ++i) {
                Name tmp = name;
                name = new Name(Integer.toHexString(addr[i] >> 4 & 0xF));
                name.setChild(tmp);
                tmp = name;
                name = new Name(Integer.toHexString(addr[i] & 0xF));
                name.setChild(tmp);
            }
        }
        return name;
    }

    @Override
    public Type getType() {
        return Type.PTR;
    }

    @Override
    public void doEncode(ByteBuffer b, Compression c) throws IOException {
        c.encodeName(this._prtdName, b);
    }

    @Override
    public void doDecode(ByteBuffer b, Compression c, int dataLength) throws IOException {
        this._prtdName = c.decodeName(b);
    }

    @Override
    public String toString() {
        if (this._prtdName == null) {
            return super.toString();
        }
        return super.toString() + " " + this._prtdName;
    }

    public Name getPrtdName() {
        return this._prtdName;
    }

    @Override
    public boolean doEquals(Record record) {
        return this.compare(this._prtdName, ((PtrRecord)record).getPrtdName());
    }
}

