/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.dns.Compression;
import org.cipango.dns.Type;
import org.cipango.dns.record.Record;
import org.cipango.dns.util.BufferUtil;

public class OptRecord
extends Record {
    public OptRecord() {
    }

    public OptRecord(int maxPayloadSize, int extendedRcode, int version, int z) {
        this.setDnsClass(BufferUtil.check16("max payload size", maxPayloadSize));
        BufferUtil.check8("Extended RCODE", extendedRcode);
        BufferUtil.check8("Version", version);
        BufferUtil.check16("z", z);
        this.setTtl((extendedRcode << 24) + (version << 16) + z);
    }

    public OptRecord(int maxPayloadSize) {
        this(maxPayloadSize, 0, 0, 0);
    }

    public int getMaxPayloadSize() {
        return this.getDnsClass();
    }

    public int getExtendedRCode() {
        return this.getTtl() >> 24 & 0xFF;
    }

    public int getVersion() {
        return this.getTtl() >> 16 & 0xFF;
    }

    public int getZ() {
        return this.getTtl() & 0xFFFF;
    }

    @Override
    public Type getType() {
        return Type.OPT;
    }

    @Override
    public void doEncode(ByteBuffer b, Compression c) throws IOException {
    }

    @Override
    public void doDecode(ByteBuffer b, Compression c, int dataLength) throws IOException {
    }

    @Override
    public boolean doEquals(Record record) {
        return true;
    }
}

