/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.dns.Compression;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.Record;

public class NsRecord
extends Record {
    private Name _nsdName;

    @Override
    public Type getType() {
        return Type.NS;
    }

    @Override
    public void doEncode(ByteBuffer b, Compression c) throws IOException {
        c.encodeName(this._nsdName, b);
    }

    @Override
    public void doDecode(ByteBuffer b, Compression c, int dataLength) throws IOException {
        this._nsdName = c.decodeName(b);
    }

    public Name getNsdName() {
        return this._nsdName;
    }

    public void setNsdName(Name nsdName) {
        this._nsdName = nsdName;
    }

    @Override
    public String toString() {
        if (this._nsdName == null) {
            return super.toString();
        }
        return super.toString() + " " + this._nsdName;
    }

    @Override
    public boolean doEquals(Record record) {
        return this.compare(this._nsdName, ((NsRecord)record).getNsdName());
    }
}

