/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.dns.Compression;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.AdditionalName;
import org.cipango.dns.record.Record;
import org.cipango.dns.util.BufferUtil;

public class NaptrRecord
extends Record
implements AdditionalName,
Comparable<NaptrRecord> {
    private int _order;
    private int _preference;
    private String _flags;
    private String _service;
    private String _regexp;
    private Name _replacement;

    public NaptrRecord() {
    }

    public NaptrRecord(String name) {
        this.setName(new Name(name));
    }

    @Override
    public Type getType() {
        return Type.NAPTR;
    }

    @Override
    public void doEncode(ByteBuffer b, Compression c) throws IOException {
        BufferUtil.put16(b, this._order);
        BufferUtil.put16(b, this._preference);
        this.encodeCharacterString(b, this._flags.getBytes());
        this.encodeCharacterString(b, this._service.getBytes());
        this.encodeCharacterString(b, this._regexp.getBytes());
        c.encodeName(this._replacement, b, true);
    }

    @Override
    public void doDecode(ByteBuffer b, Compression c, int dataLength) throws IOException {
        this._order = BufferUtil.get16(b);
        this._preference = BufferUtil.get16(b);
        this._flags = new String(this.decodeCharacterString(b));
        this._service = new String(this.decodeCharacterString(b));
        this._regexp = new String(this.decodeCharacterString(b));
        this._replacement = c.decodeName(b);
    }

    @Override
    public String toString() {
        if (this._replacement == null) {
            return super.toString();
        }
        return super.toString() + " " + this._order + " " + this._preference + " \"" + this._flags + "\" \"" + this._service + "\" \"" + this._regexp + "\" " + this._replacement;
    }

    @Override
    public Name getAdditionalName() {
        return this._replacement;
    }

    public int getOrder() {
        return this._order;
    }

    public int getPreference() {
        return this._preference;
    }

    public String getFlags() {
        return this._flags;
    }

    public String getService() {
        return this._service;
    }

    public String getRegexp() {
        return this._regexp;
    }

    public Name getReplacement() {
        return this._replacement;
    }

    @Override
    public boolean doEquals(Record record) {
        NaptrRecord naptrRecord = (NaptrRecord)record;
        return this.compare(this._regexp, naptrRecord.getRegexp()) && this.compare(this._replacement, naptrRecord.getReplacement()) && this.compare(this._service, naptrRecord.getService());
    }

    @Override
    public int compareTo(NaptrRecord o2) {
        int order = this.getOrder() - o2.getOrder();
        if (order != 0) {
            return order;
        }
        int pref = this.getPreference() - o2.getPreference();
        if (pref != 0) {
            return pref;
        }
        return this.hashCode() - o2.hashCode();
    }
}

