/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.dns.Compression;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.AdditionalName;
import org.cipango.dns.record.Record;

public class CnameRecord
extends Record
implements AdditionalName {
    private Name _cname;

    @Override
    public Type getType() {
        return Type.CNAME;
    }

    @Override
    public void doEncode(ByteBuffer b, Compression c) throws IOException {
        c.encodeName(this._cname, b);
    }

    @Override
    public void doDecode(ByteBuffer b, Compression c, int dataLength) throws IOException {
        this._cname = c.decodeName(b);
    }

    @Override
    public String toString() {
        if (this._cname == null) {
            return super.toString();
        }
        return super.toString() + " " + this._cname;
    }

    public Name getCname() {
        return this._cname;
    }

    public void setCname(Name cname) {
        this._cname = cname;
    }

    @Override
    public Name getAdditionalName() {
        return this._cname;
    }

    @Override
    public boolean doEquals(Record record) {
        return this.compare(this._cname, ((CnameRecord)record).getCname());
    }
}

