/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.record;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.cipango.dns.Compression;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.Record;
import org.cipango.dns.util.BufferUtil;

public class AaaaRecord
extends Record {
    private InetAddress _address;

    public AaaaRecord() {
    }

    public AaaaRecord(Name name) {
        this.setName(name);
    }

    public AaaaRecord(String name) {
        this.setName(new Name(name));
    }

    @Override
    public Type getType() {
        return Type.AAAA;
    }

    @Override
    public void doEncode(ByteBuffer b, Compression c) throws IOException {
        b.put(this._address.getAddress());
    }

    @Override
    public void doDecode(ByteBuffer b, Compression c, int dataLength) throws IOException {
        if (dataLength != 16) {
            throw new IOException("Invalid RDlength in AAAA record");
        }
        this._address = InetAddress.getByAddress(this.getName().toString(), BufferUtil.getBytes(b, 16));
    }

    public InetAddress getAddress() {
        return this._address;
    }

    public void setAddress(InetAddress address) {
        this._address = address;
    }

    @Override
    public String toString() {
        if (this._address == null) {
            return super.toString();
        }
        return super.toString() + " " + this._address.getHostAddress();
    }

    @Override
    public boolean doEquals(Record record) {
        return this.compare(this._address, ((AaaaRecord)record).getAddress());
    }
}

