/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.record;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.cipango.dns.Compression;
import org.cipango.dns.Name;
import org.cipango.dns.Type;
import org.cipango.dns.record.Record;
import org.cipango.dns.util.BufferUtil;

public class ARecord
extends Record {
    private InetAddress _address;

    public ARecord() {
    }

    public ARecord(String name) {
        this.setName(new Name(name));
    }

    public ARecord(Name name) {
        this.setName(name);
    }

    @Override
    public Type getType() {
        return Type.A;
    }

    public InetAddress getAddress() {
        return this._address;
    }

    @Override
    public void doDecode(ByteBuffer b, Compression c, int dataLength) throws IOException {
        if (dataLength != 4) {
            throw new IOException("Invalid RDLENGTH: " + dataLength + " in A record");
        }
        this._address = InetAddress.getByAddress(this.getName().toString(), BufferUtil.getBytes(b, 4));
    }

    @Override
    public void doEncode(ByteBuffer b, Compression c) throws IOException {
        b.put(this._address.getAddress());
    }

    @Override
    public String toString() {
        if (this._address == null) {
            return super.toString();
        }
        return super.toString() + " " + this._address.getHostAddress();
    }

    @Override
    public boolean doEquals(Record record) {
        return this.compare(this._address, ((ARecord)record).getAddress());
    }

    public void setAddress(InetAddress address) {
        this._address = address;
    }
}

