/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.bio;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.RejectedExecutionException;
import org.cipango.dns.AbstractConnector;
import org.cipango.dns.DnsConnection;
import org.cipango.dns.DnsMessage;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class UdpConnector
extends AbstractConnector {
    public static final int DEFAULT_MAX_PACKET_SIZE = 512;
    private static final Logger LOG = Log.getLogger(UdpConnector.class);
    private DatagramSocket _socket;
    private Acceptor _acceptor;
    private int _maxPacketSize = 512;
    private int _port;

    @ManagedAttribute(value="Port", readonly=true)
    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        if (port < 0 || port > 65536) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        this._port = port;
    }

    protected void doStop() throws Exception {
        if (this._socket != null) {
            this._socket.close();
        }
        this._socket = null;
        if (this._acceptor != null) {
            this._acceptor.close();
        }
        this._acceptor = null;
        super.doStop();
    }

    @Override
    public DnsConnection getConnection(InetAddress host, int port) {
        return new Connection(host, port);
    }

    public synchronized DatagramSocket getDatagramSocket() throws SocketException {
        if (this._socket == null || this._socket.isClosed()) {
            this._socket = new DatagramSocket(this.getPort(), this.getHostAddr());
            this._socket.setSoTimeout(this.getTimeout());
            LOG.debug("Create the new datagram socket {} for DNS connector", new Object[]{this._socket.getLocalSocketAddress()});
            this._acceptor = new Acceptor();
            this._acceptor.dispatch();
        }
        return this._socket;
    }

    public int getMaxPacketSize() {
        return this._maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        if (this._maxPacketSize < 512) {
            throw new IllegalArgumentException("Invalid max packet size: " + maxPacketSize);
        }
        this._maxPacketSize = maxPacketSize;
    }

    @Override
    public boolean isTcp() {
        return false;
    }

    public class Connection
    implements DnsConnection {
        private InetAddress _remoteAddr;
        private int _remotePort;
        private DatagramSocket _socket;

        public Connection(InetAddress remoteAddr, int remotePort) {
            this._remoteAddr = remoteAddr;
            this._remotePort = remotePort;
        }

        @Override
        public void send(DnsMessage message) throws IOException {
            int maxSize = message.getMaxUdpSize();
            if (maxSize > UdpConnector.this._maxPacketSize) {
                UdpConnector.this.setMaxPacketSize(maxSize);
            }
            ByteBuffer buffer = ByteBuffer.allocate(maxSize);
            message.encode(buffer);
            DatagramPacket packet = new DatagramPacket(buffer.array(), buffer.position(), this._remoteAddr, this._remotePort);
            UdpConnector.this.addQuery(message);
            this._socket = UdpConnector.this.getDatagramSocket();
            this._socket.send(packet);
        }

        @Override
        public DnsMessage waitAnswer(DnsMessage request, int timeout) {
            return UdpConnector.this.waitAnswer(request, timeout);
        }

        public DatagramSocket getSocket() {
            return this._socket;
        }
    }

    public class Acceptor
    implements Runnable {
        private DatagramSocket _datagramSocket;

        public Acceptor() {
            this._datagramSocket = UdpConnector.this._socket;
        }

        @Override
        public void run() {
            while (this._datagramSocket != null && this._datagramSocket == UdpConnector.this._socket && !this._datagramSocket.isClosed()) {
                try {
                    DatagramPacket packet = new DatagramPacket(new byte[UdpConnector.this._maxPacketSize], UdpConnector.this._maxPacketSize);
                    this._datagramSocket.receive(packet);
                    DnsMessage answer = new DnsMessage();
                    answer.decode(ByteBuffer.wrap(packet.getData()));
                    UdpConnector.this.updateQueryOnAnswer(answer);
                }
                catch (IOException e) {
                    this.close();
                }
            }
            this.close();
            LOG.debug("DNS acceptor done", new Object[0]);
        }

        private void close() {
            if (this._datagramSocket != null && !this._datagramSocket.isClosed()) {
                this._datagramSocket.close();
            }
            this._datagramSocket = null;
        }

        public void dispatch() {
            try {
                UdpConnector.this.getExecutor().execute(this);
            }
            catch (RejectedExecutionException e) {
                LOG.warn("dispatch failed for {}", new Object[]{this});
                this.close();
            }
        }
    }
}

