/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns.bio;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.cipango.dns.AbstractConnector;
import org.cipango.dns.DnsConnection;
import org.cipango.dns.DnsMessage;
import org.cipango.dns.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class TcpConnector
extends AbstractConnector {
    public static final int MIN_BOUNDED_PORT = 1024;
    public static final int MAX_BOUNDED_PORT = 65535;
    public static final int MAX_PACKET_SIZE = 65536;
    private static final Logger LOG = Log.getLogger(TcpConnector.class);
    private Map<String, Connection> _connections = new HashMap<String, Connection>(3);
    private int _minPort;
    private int _maxPort;
    private int _currentPort;

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._maxPort == 0 && this._minPort != 0) {
            this._maxPort = 65535;
        }
        if (this._minPort == 0 && this._maxPort != 0) {
            this._minPort = 1024;
        }
        if (this._minPort > this._maxPort && this._minPort != 0) {
            throw new IllegalArgumentException("minPort > maxPort");
        }
        this._currentPort = this._minPort - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        Map<String, Connection> map = this._connections;
        synchronized (map) {
            for (Connection connection : this._connections.values()) {
                connection.close();
            }
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DnsConnection getConnection(InetAddress host, int port) throws IOException {
        Connection cnx = null;
        Map<String, Connection> map = this._connections;
        synchronized (map) {
            cnx = this._connections.get(this.key(host, port));
            if (cnx == null || !cnx.isOpen()) {
                cnx = this.newConnection(host, port);
                this._connections.put(this.key(host, port), cnx);
                cnx.dispatch();
            }
        }
        return cnx;
    }

    protected Connection newConnection(InetAddress host, int port) throws IOException {
        return new Connection(host, port);
    }

    private String key(InetAddress addr, int port) {
        return addr.getHostAddress() + ":" + port;
    }

    public int getMinPort() {
        return this._minPort;
    }

    public void setMinPort(int minPort) {
        this._minPort = minPort;
        this._currentPort = this._minPort - 1;
    }

    public int getMaxPort() {
        return this._maxPort;
    }

    public void setMaxPort(int maxPort) {
        this._maxPort = maxPort;
    }

    public int getCurrentPort() {
        return this._currentPort;
    }

    @Override
    public boolean isTcp() {
        return true;
    }

    public class Connection
    implements DnsConnection,
    Runnable {
        private Socket _socket = this.newSocket();

        public Connection(InetAddress remoteAddr, int remotePort) throws IOException {
            this._socket.setSoTimeout(TcpConnector.this.getTimeout());
            this._socket.connect(new InetSocketAddress(remoteAddr, remotePort));
            LOG.debug("Create the new socket {} for DNS TCP connector", new Object[]{this._socket});
        }

        protected Socket newSocket() throws BindException {
            if (TcpConnector.this.getHostAddr() != null || TcpConnector.this.getMinPort() != 0) {
                Socket socket = null;
                int range = TcpConnector.this._maxPort - TcpConnector.this._minPort;
                int testedPort = TcpConnector.this._currentPort;
                for (int i = 0; i <= range; ++i) {
                    try {
                        testedPort = testedPort == TcpConnector.this._maxPort ? TcpConnector.this._minPort : ++testedPort;
                        socket = new Socket();
                        socket.setReuseAddress(false);
                        socket.bind(new InetSocketAddress(TcpConnector.this.getHostAddr(), testedPort));
                        TcpConnector.this._currentPort = testedPort;
                        break;
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
                if (socket == null || !socket.isBound()) {
                    throw new BindException("Could not found available local port between " + TcpConnector.this._minPort + " and " + TcpConnector.this._maxPort);
                }
                return socket;
            }
            return new Socket();
        }

        @Override
        public void send(DnsMessage message) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            buffer.position(2);
            message.encode(buffer);
            int size = buffer.position() + 2;
            buffer.position(0);
            BufferUtil.put16(buffer, size);
            TcpConnector.this.addQuery(message);
            this._socket.getOutputStream().write(buffer.array(), 0, size + 2);
            this._socket.getOutputStream().flush();
        }

        @Override
        public DnsMessage waitAnswer(DnsMessage request, int timeout) {
            return TcpConnector.this.waitAnswer(request, timeout);
        }

        public Socket getSocket() {
            return this._socket;
        }

        @Override
        public void run() {
            while (this._socket != null && !this._socket.isClosed()) {
                try {
                    int size1 = this._socket.getInputStream().read();
                    int size2 = this._socket.getInputStream().read();
                    int size = (size1 & 0xFF) << 8 | size2 & 0xFF;
                    byte[] buffer = new byte[size];
                    int read = 0;
                    while (read < size) {
                        int read2 = this._socket.getInputStream().read(buffer, read, size - read);
                        if (read2 == -1) continue;
                        read += read2;
                    }
                    DnsMessage answer = new DnsMessage();
                    answer.decode(ByteBuffer.wrap(buffer));
                    TcpConnector.this.updateQueryOnAnswer(answer);
                }
                catch (IOException e) {
                    this.close();
                }
            }
            this.close();
            LOG.debug("DNS acceptor done", new Object[0]);
        }

        public boolean isOpen() {
            return this._socket != null && !this._socket.isClosed();
        }

        public void dispatch() throws IOException {
            try {
                TcpConnector.this.getExecutor().execute(this);
            }
            catch (RejectedExecutionException e) {
                LOG.warn("dispatch failed for {}", new Object[]{this});
                this.close();
            }
        }

        public void close() {
            try {
                if (this._socket != null && !this._socket.isClosed()) {
                    this._socket.close();
                }
                this._socket = null;
            }
            catch (Exception e) {
                LOG.warn("Failed to close socket: " + this._socket, (Throwable)e);
            }
        }
    }
}

