/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cipango.dns.record.ARecord;
import org.cipango.dns.record.AaaaRecord;
import org.cipango.dns.record.CnameRecord;
import org.cipango.dns.record.GenericRecord;
import org.cipango.dns.record.NaptrRecord;
import org.cipango.dns.record.NsRecord;
import org.cipango.dns.record.PtrRecord;
import org.cipango.dns.record.Record;
import org.cipango.dns.record.SoaRecord;
import org.cipango.dns.record.SrvRecord;
import org.cipango.dns.util.BufferUtil;

public enum Type {
    A(1, ARecord.class),
    NS(2, NsRecord.class),
    MD(3),
    MF(4),
    CNAME(5, CnameRecord.class),
    SOA(6, SoaRecord.class),
    MB(7),
    MG(8),
    MR(9),
    NULL(10),
    WKS(11),
    PTR(12, PtrRecord.class),
    HINFO(13),
    MINFO(14),
    MX(15),
    TXT(16),
    RP(17),
    AFSDB(18),
    X25(19),
    ISDN(20),
    RT(21),
    NSAP(22),
    NSAP_PTR(23),
    SIG(24),
    KEY(25),
    PX(26),
    GPOS(27),
    AAAA(28, AaaaRecord.class),
    LOC(29),
    NXT(30),
    EID(31),
    NIMLOC(32),
    SRV(33, SrvRecord.class),
    ATMA(34),
    NAPTR(35, NaptrRecord.class),
    KX(36),
    CERT(37),
    A6(38),
    DNAME(39),
    OPT(41),
    APL(42),
    DS(43),
    SSHFP(44),
    IPSECKEY(45),
    RRSIG(46),
    NSEC(47),
    DNSKEY(48),
    DHCID(49),
    NSEC3(50),
    NSEC3PARAM(51),
    SPF(99),
    TKEY(249),
    TSIG(250),
    IXFR(251),
    AXFR(252),
    MAILB(253),
    MAILA(254),
    ANY(255);

    private int _value;
    private Class<? extends Record> _class;

    private Type(int value) {
        this._value = value;
    }

    private Type(int value, Class<? extends Record> clazz) {
        this._value = value;
        this._class = clazz;
    }

    public int getValue() {
        return this._value;
    }

    public void encode(ByteBuffer b) {
        BufferUtil.put16(b, this._value);
    }

    public Record newRecord() throws IOException {
        try {
            if (this._class == null) {
                return new GenericRecord(this);
            }
            return this._class.newInstance();
        }
        catch (Exception e) {
            throw new IOException("Could not create record with class " + this._class + ":" + e);
        }
    }

    public static Type getType(int value) throws IOException {
        for (Type t : Type.values()) {
            if (t.getValue() != value) continue;
            return t;
        }
        throw new IOException("Could not found type with value: " + value);
    }
}

