/*
 * Decompiled with CFR 0.152.
 */
package org.cipango.dns;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.cipango.dns.DnsClient;
import org.cipango.dns.DnsConnection;
import org.cipango.dns.DnsConnector;
import org.cipango.dns.DnsMessage;
import org.cipango.dns.record.OptRecord;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="DNS resolver")
public class Resolver {
    public static final int DEFAULT_PORT = 53;
    public static final int DEFAULT_TIMEOUT = 1000;
    private static final Logger LOG = Log.getLogger(Resolver.class);
    private DnsClient _dnsClient;
    private InetAddress _host;
    private int _port = 53;
    private long _timeout = 1000L;
    private int _attempts = 2;
    private OptRecord _queryOpt;

    public Resolver() {
    }

    public Resolver(String host) throws UnknownHostException {
        this.setHost(host);
    }

    public DnsMessage resolve(DnsMessage query) throws IOException {
        DnsConnection c = this._dnsClient.getDefaultConnector().getConnection(this._host, this._port);
        if (this._queryOpt != null && query.getAdditionalSection().get(OptRecord.class) == null) {
            query.getAdditionalSection().add(this._queryOpt);
        }
        int timeout = (int)this._timeout;
        for (int i = 0; i < this._attempts; ++i) {
            c.send(query);
            DnsMessage answer = c.waitAnswer(query, timeout);
            if (answer != null) {
                if (answer.getHeaderSection().isTruncated() && !this._dnsClient.getDefaultConnector().isTcp()) {
                    DnsConnector tcpConnector = this._dnsClient.getTcpConnector();
                    if (tcpConnector == null) {
                        LOG.debug("Ignore truncated flag as there is no TCP connector", new Object[0]);
                    } else {
                        c = tcpConnector.getConnection(this._host, this._port);
                        c.send(query);
                        answer = c.waitAnswer(query, timeout);
                        if (answer == null) {
                            throw new SocketTimeoutException("No response received for query " + query.getQuestionSection());
                        }
                        return answer;
                    }
                }
                return answer;
            }
            this.timeout(query);
        }
        throw new SocketTimeoutException("No response received for query " + query.getQuestionSection());
    }

    protected void timeout(DnsMessage query) {
    }

    @ManagedAttribute(value="Host", readonly=true)
    public InetAddress getHost() {
        return this._host;
    }

    public void setHost(String host) throws UnknownHostException {
        this._host = InetAddress.getByName(host);
    }

    public void setHost(InetAddress host) {
        this._host = host;
    }

    @ManagedAttribute(value="Port", readonly=true)
    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port;
    }

    @ManagedAttribute(value="Timeout")
    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    @ManagedAttribute(value="Attempts")
    public int getAttempts() {
        return this._attempts;
    }

    public void setAttempts(int attempts) {
        this._attempts = attempts;
    }

    public DnsClient getDnsClient() {
        return this._dnsClient;
    }

    public void setDnsClient(DnsClient dnsClient) {
        this._dnsClient = dnsClient;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this._host.getHostAddress() + ":" + this._port;
    }

    public OptRecord getQueryOpt() {
        return this._queryOpt;
    }

    public void setQueryOpt(OptRecord queryOpt) {
        this._queryOpt = queryOpt;
    }
}

